/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin.user;

import com.zutubi.pulse.model.Group;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.web.admin.user.GroupActionSupport;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddGroupMembersAction
extends GroupActionSupport {
    private LinkedHashMap<Long, String> nonMembers;
    private List<Long> members;
    private int startPage;

    public Map<Long, String> getNonMembers() {
        if (this.nonMembers == null) {
            this.nonMembers = new LinkedHashMap();
            Group group = this.getGroup();
            if (group != null) {
                List<User> nons = this.getUserManager().getUsersNotInGroup(group);
                final Collator collator = Collator.getInstance();
                Collections.sort(nons, new Comparator<User>(){

                    @Override
                    public int compare(User user1, User user2) {
                        return collator.compare(user1.getName(), user2.getName());
                    }
                });
                for (User u : nons) {
                    this.nonMembers.put(u.getId(), u.getLogin() + " (" + u.getName() + ")");
                }
            }
        }
        return this.nonMembers;
    }

    public List<Long> getMembers() {
        return this.members;
    }

    public void setMembers(List<Long> members) {
        this.members = members;
    }

    public String doInput() throws Exception {
        if (this.getGroup() == null) {
            this.addActionError("Unknown group [" + this.getGroupId() + "]");
            return "error";
        }
        return "input";
    }

    public String execute() throws Exception {
        if (this.members != null) {
            Group group = this.getGroup();
            if (group == null) {
                this.addActionError("Unknown group [" + this.getGroupId() + "]");
                return "error";
            }
            for (Long userId : this.members) {
                User user = this.getUserManager().getUser(userId);
                if (user == null) continue;
                group.addUser(user);
            }
            this.getUserManager().save(group);
        }
        return "success";
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }
}

