/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin;

import com.zutubi.pulse.bootstrap.MasterConfiguration;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.web.ActionSupport;

public class SmtpConfigurationAction
extends ActionSupport {
    private MasterConfigurationManager configurationManager;
    private SmtpConfig smtp = new SmtpConfig();

    public SmtpConfig getSmtp() {
        return this.smtp;
    }

    public String doReset() {
        this.resetConfig();
        this.loadConfig();
        return "success";
    }

    public String doSave() {
        this.saveConfig();
        return "success";
    }

    public String doInput() {
        this.loadConfig();
        return "input";
    }

    public String execute() {
        this.loadConfig();
        return "success";
    }

    private void resetConfig() {
        MasterConfiguration config = this.configurationManager.getAppConfig();
        config.setSmtpPrefix(null);
        config.setSmtpFrom(null);
        config.setSmtpHost(null);
        config.setSmtpSSL(false);
        config.setSmtpPort(-1);
        config.setSmtpUsername(null);
        config.setSmtpPassword(null);
    }

    private void saveConfig() {
        MasterConfiguration config = this.configurationManager.getAppConfig();
        config.setSmtpPrefix(this.smtp.getPrefix());
        config.setSmtpFrom(this.smtp.getFrom());
        config.setSmtpHost(this.smtp.getHost());
        config.setSmtpSSL(this.smtp.getSsl());
        config.setSmtpUsername(this.smtp.getUsername());
        config.setSmtpPassword(this.smtp.getPassword());
        if (this.smtp.getCustomPort()) {
            config.setSmtpPort(this.smtp.getPort());
        } else {
            config.setSmtpPort(-1);
        }
    }

    private void loadConfig() {
        MasterConfiguration config = this.configurationManager.getAppConfig();
        this.smtp.setPrefix(config.getSmtpPrefix());
        this.smtp.setFrom(config.getSmtpFrom());
        this.smtp.setHost(config.getSmtpHost());
        this.smtp.setSsl(config.getSmtpSSL());
        this.smtp.setUsername(config.getSmtpUsername());
        this.smtp.setPassword(config.getSmtpPassword());
        int port = config.getSmtpPort();
        if (port > 0) {
            this.smtp.setCustomPort(true);
            this.smtp.setPort(port);
        } else {
            this.smtp.setCustomPort(false);
            this.smtp.setPort(config.getSmtpSSL() ? 465 : 25);
        }
    }

    public void setConfigurationManager(MasterConfigurationManager config) {
        this.configurationManager = config;
    }

    public class SmtpConfig {
        private String from;
        private boolean ssl;
        private String prefix;
        private String host;
        private String username;
        private String password;
        private boolean customPort;
        private int port;

        public String getFrom() {
            return this.from;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public boolean getSsl() {
            return this.ssl;
        }

        public void setSsl(boolean ssl) {
            this.ssl = ssl;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String prefix) {
            this.prefix = prefix;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public boolean getCustomPort() {
            return this.customPort;
        }

        public void setCustomPort(boolean customPort) {
            this.customPort = customPort;
        }

        public int getPort() {
            return this.port;
        }

        public void setPort(int port) {
            this.port = port;
        }
    }
}

