/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin;

import com.zutubi.pulse.agent.AgentManager;
import com.zutubi.pulse.bootstrap.MasterConfiguration;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.jabber.JabberManager;
import com.zutubi.pulse.license.License;
import com.zutubi.pulse.license.LicenseHolder;
import com.zutubi.pulse.model.CommitMessageTransformer;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.security.ldap.LdapManager;
import com.zutubi.pulse.web.ActionSupport;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerSettingsAction
extends ActionSupport {
    private MasterConfigurationManager configurationManager;
    private JabberManager jabberManager;
    private MasterConfiguration config;
    private DateFormat dateFormatter = new SimpleDateFormat("EEEEE, dd MMM yyyy");
    private LdapManager ldapManager;
    private List<CommitMessageTransformer> commitMessageTransformers;
    private AgentManager agentManager;
    private UserManager userManager;
    private License license;
    private List<LicenseRestriction> restrictions;

    public MasterConfiguration getConfig() {
        return this.config;
    }

    public String getJabberStatus() {
        return this.jabberManager.getStatusMessage();
    }

    public String getLdapStatus() {
        return this.ldapManager.getStatusMessage();
    }

    public List<CommitMessageTransformer> getCommitMessageTransformers() {
        return this.commitMessageTransformers;
    }

    public boolean isRecipeTimeoutEnabled() {
        return this.config.getUnsatisfiableRecipeTimeout() >= 0L;
    }

    public int getSupportedContactPoints() {
        return LicenseHolder.getLicense().getSupportedContactPoints();
    }

    public String execute() throws Exception {
        this.config = this.configurationManager.getAppConfig();
        this.commitMessageTransformers = this.commitMessageTransformerManager.getCommitMessageTransformers();
        this.license = LicenseHolder.getLicense();
        this.restrictions = new LinkedList<LicenseRestriction>();
        this.restrictions.add(new LicenseRestriction("agents", this.license.getSupportedAgents(), this.agentManager.getAgentCount()));
        this.restrictions.add(new LicenseRestriction("projects", this.license.getSupportedProjects(), this.projectManager.getProjectCount()));
        this.restrictions.add(new LicenseRestriction("users", this.license.getSupportedUsers(), this.userManager.getUserCount()));
        return "success";
    }

    public List<LicenseRestriction> getRestrictions() {
        return this.restrictions;
    }

    public String getExpiryDate() {
        if (this.license.expires()) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(this.license.getExpiryDate());
            cal.set(10, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            return this.dateFormatter.format(cal.getTime());
        }
        return "Never";
    }

    public String getUnrestricted() {
        return this.getText("license.unrestricted");
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setJabberManager(JabberManager jabberManager) {
        this.jabberManager = jabberManager;
    }

    public void setLdapManager(LdapManager ldapManager) {
        this.ldapManager = ldapManager;
    }

    public void setAgentManager(AgentManager agentManager) {
        this.agentManager = agentManager;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public static class LicenseRestriction {
        private String entity;
        private int supported;
        private int inUse;

        public LicenseRestriction(String entity, int supported, int inUse) {
            this.entity = entity;
            this.supported = supported;
            this.inUse = inUse;
        }

        public String getEntity() {
            return this.entity;
        }

        public int getSupported() {
            return this.supported;
        }

        public int getInUse() {
            return this.inUse;
        }
    }
}

