/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin;

import com.zutubi.pulse.license.License;
import com.zutubi.pulse.license.LicenseDecoder;
import com.zutubi.pulse.license.LicenseException;
import com.zutubi.pulse.license.LicenseManager;
import com.zutubi.pulse.web.ActionSupport;

public class ManageLicenseAction
extends ActionSupport {
    private LicenseManager licenseManager;
    private String license;

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        try {
            String licenseKey = this.license.replaceAll("\n", "");
            License l = new LicenseDecoder().decode(licenseKey.getBytes());
            if (l.isExpired()) {
                this.addFieldError("license", this.getText("license.key.expired"));
            }
        }
        catch (LicenseException e) {
            this.addActionError(this.getText("license.key.valdiation.error", e.getMessage()));
        }
    }

    public String doSave() {
        return this.execute();
    }

    public String execute() {
        try {
            this.licenseManager.installLicense(this.license);
            return "success";
        }
        catch (LicenseException e) {
            this.addActionError(this.getText("license.key.update.error", e.getMessage()));
            return "error";
        }
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }
}

