/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin;

import com.zutubi.pulse.bootstrap.MasterConfiguration;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.logging.LogConfigurationManager;
import com.zutubi.pulse.web.ActionSupport;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogConfigurationAction
extends ActionSupport {
    private String config;
    private boolean eventLoggingEnabled;
    private List<String> configs;
    private LogConfigurationManager logConfigurationManager;
    private MasterConfigurationManager configurationManager;

    public String doReset() {
        this.resetConfig();
        this.loadConfig();
        return "success";
    }

    public String doInput() {
        this.loadConfig();
        return "input";
    }

    public String doSave() {
        this.saveConfig();
        this.logConfigurationManager.updateConfiguration(this.config);
        this.logConfigurationManager.setEventLoggingEnabled(this.eventLoggingEnabled);
        return "success";
    }

    public String execute() {
        this.loadConfig();
        return "success";
    }

    private void saveConfig() {
        MasterConfiguration logConfig = this.configurationManager.getAppConfig();
        logConfig.setLoggingLevel(this.config);
        logConfig.setEventLoggingEnabled(this.eventLoggingEnabled);
    }

    private void loadConfig() {
        this.configs = this.logConfigurationManager.getAvailableConfigurations();
        MasterConfiguration logConfig = this.configurationManager.getAppConfig();
        this.config = logConfig.getLoggingLevel();
        this.eventLoggingEnabled = logConfig.isEventLoggingEnabled();
    }

    private void resetConfig() {
        MasterConfiguration logConfig = this.configurationManager.getAppConfig();
        logConfig.setEventLoggingEnabled(false);
        logConfig.setLoggingLevel(null);
    }

    public List<String> getConfigs() {
        return this.configs;
    }

    public boolean isEventLoggingEnabled() {
        return this.eventLoggingEnabled;
    }

    public void setEventLoggingEnabled(boolean eventLoggingEnabled) {
        this.eventLoggingEnabled = eventLoggingEnabled;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public void setLogConfigurationManager(LogConfigurationManager logConfigurationManager) {
        this.logConfigurationManager = logConfigurationManager;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

