/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.bootstrap.MasterConfiguration;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.security.ldap.LdapManager;
import com.zutubi.pulse.web.ActionSupport;

public class LdapConfigurationAction
extends ActionSupport {
    private MasterConfigurationManager configurationManager;
    private LdapConfig ldap = new LdapConfig();
    private LdapManager ldapManager;

    public LdapConfig getLdap() {
        return this.ldap;
    }

    public String doReset() {
        this.resetConfig();
        this.loadConfig();
        return "success";
    }

    public String doSave() {
        this.saveConfig();
        return "success";
    }

    public String doInput() {
        this.loadConfig();
        return "input";
    }

    public void validate() {
        if (this.ldap.getEnabled().booleanValue()) {
            if (!TextUtils.stringSet((String)this.ldap.getHost())) {
                this.addFieldError("ldap.host", this.getText("ldap.host.url.required"));
            }
            if (!TextUtils.stringSet((String)this.ldap.getBaseDn())) {
                this.addFieldError("ldap.baseDn", this.getText("ldap.base.dn.required"));
            }
            if (!TextUtils.stringSet((String)this.ldap.getUserFilter())) {
                this.addFieldError("ldap.userFilter", this.getText("ldap.user.filter.required"));
            }
        }
    }

    public String execute() {
        this.loadConfig();
        return "success";
    }

    private void resetConfig() {
        MasterConfiguration config = this.configurationManager.getAppConfig();
        config.setLdapEnabled(false);
        config.setLdapHostUrl("");
        config.setLdapBaseDn("");
        config.setLdapManagerDn("");
        config.setLdapManagerPassword("");
        config.setLdapUserFilter("");
        config.setLdapEmailAttribute("");
        config.setLdapAutoAdd(false);
        config.setLdapGroupBaseDn("");
        config.setLdapGroupFilter("");
        config.setLdapGroupRoleAttribute("");
        config.setLdapGroupSearchSubtree(false);
        config.setLdapEscapeSpaces(false);
        this.ldapManager.init();
    }

    private void saveConfig() {
        MasterConfiguration config = this.configurationManager.getAppConfig();
        config.setLdapEnabled(this.ldap.getEnabled());
        config.setLdapHostUrl(this.ldap.getHost());
        config.setLdapBaseDn(this.ldap.getBaseDn());
        config.setLdapManagerDn(this.ldap.getManagerDn());
        config.setLdapManagerPassword(this.ldap.getManagerPassword());
        config.setLdapUserFilter(this.ldap.getUserFilter());
        config.setLdapAutoAdd(this.ldap.getAutoAdd());
        config.setLdapEmailAttribute(this.ldap.getEmailAttribute());
        config.setLdapGroupBaseDn(this.ldap.getGroupBaseDn());
        config.setLdapGroupFilter(this.ldap.getGroupFilter());
        config.setLdapGroupRoleAttribute(this.ldap.getGroupRoleAttribute());
        config.setLdapGroupSearchSubtree(this.ldap.getGroupSearchSubtree());
        config.setLdapEscapeSpaces(this.ldap.getEscapeSpaces());
        this.ldapManager.init();
        if (this.ldap.getEnabled().booleanValue()) {
            this.ldapManager.connect();
        }
    }

    private void loadConfig() {
        MasterConfiguration config = this.configurationManager.getAppConfig();
        this.ldap.setEnabled(config.getLdapEnabled());
        this.ldap.setHost(config.getLdapHostUrl());
        this.ldap.setBaseDn(config.getLdapBaseDn());
        this.ldap.setManagerDn(config.getLdapManagerDn());
        this.ldap.setManagerPassword(config.getLdapManagerPassword());
        this.ldap.setUserFilter(config.getLdapUserFilter());
        this.ldap.setAutoAdd(config.getLdapAutoAdd());
        this.ldap.setEmailAttribute(config.getLdapEmailAttribute());
        this.ldap.setGroupBaseDn(config.getLdapGroupBaseDn());
        this.ldap.setGroupFilter(config.getLdapGroupFilter());
        this.ldap.setGroupRoleAttribute(config.getLdapGroupRoleAttribute());
        this.ldap.setGroupSearchSubtree(config.getLdapGroupSearchSubtree());
        this.ldap.setEscapeSpaces(config.getLdapEscapeSpaces());
    }

    public void setConfigurationManager(MasterConfigurationManager config) {
        this.configurationManager = config;
    }

    public void setLdapManager(LdapManager ldapManager) {
        this.ldapManager = ldapManager;
    }

    public class LdapConfig {
        private Boolean enabled = false;
        private String host;
        private String baseDn;
        private String managerDn;
        private String managerPassword;
        private String userFilter;
        private Boolean autoAdd = false;
        private String emailAttribute;
        private String groupBaseDn;
        private String groupFilter;
        private String groupRoleAttribute;
        private Boolean groupSearchSubtree = false;
        private Boolean escapeSpaces = false;

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public String getBaseDn() {
            return this.baseDn;
        }

        public void setBaseDn(String baseDn) {
            this.baseDn = baseDn;
        }

        public String getManagerDn() {
            return this.managerDn;
        }

        public void setManagerDn(String managerDn) {
            this.managerDn = managerDn;
        }

        public String getManagerPassword() {
            return this.managerPassword;
        }

        public void setManagerPassword(String managerPassword) {
            this.managerPassword = managerPassword;
        }

        public String getUserFilter() {
            return this.userFilter;
        }

        public void setUserFilter(String userFilter) {
            this.userFilter = userFilter;
        }

        public Boolean getAutoAdd() {
            return this.autoAdd;
        }

        public void setAutoAdd(Boolean autoAdd) {
            this.autoAdd = autoAdd;
        }

        public String getEmailAttribute() {
            return this.emailAttribute;
        }

        public void setEmailAttribute(String emailAttribute) {
            this.emailAttribute = emailAttribute;
        }

        public String getGroupBaseDn() {
            return this.groupBaseDn;
        }

        public void setGroupBaseDn(String groupBaseDn) {
            this.groupBaseDn = groupBaseDn;
        }

        public String getGroupFilter() {
            return this.groupFilter;
        }

        public void setGroupFilter(String groupFilter) {
            this.groupFilter = groupFilter;
        }

        public String getGroupRoleAttribute() {
            return this.groupRoleAttribute;
        }

        public void setGroupRoleAttribute(String groupRoleAttribute) {
            this.groupRoleAttribute = groupRoleAttribute;
        }

        public Boolean getGroupSearchSubtree() {
            return this.groupSearchSubtree;
        }

        public void setGroupSearchSubtree(Boolean groupSearchSubtree) {
            this.groupSearchSubtree = groupSearchSubtree;
        }

        public Boolean getEscapeSpaces() {
            return this.escapeSpaces;
        }

        public void setEscapeSpaces(Boolean escapeSpaces) {
            this.escapeSpaces = escapeSpaces;
        }
    }
}

