/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin;

import com.zutubi.pulse.GuestAccessManager;
import com.zutubi.pulse.ThreadedRecipeQueue;
import com.zutubi.pulse.bootstrap.MasterConfiguration;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.web.ActionSupport;

public class GeneralConfigurationAction
extends ActionSupport {
    private MasterConfigurationManager configurationManager;
    private GuestAccessManager guestAccessManager;
    private String baseUrl;
    private String helpUrl;
    private boolean rssEnabled;
    private boolean anonEnabled;
    private boolean signupEnabled;
    private Integer scmPollingInterval;
    private boolean recipeTimeoutEnabled;
    private Long recipeTimeout;
    private ThreadedRecipeQueue recipeQueue;

    public String doReset() {
        this.resetConfig();
        this.loadConfig();
        return "success";
    }

    public String doSave() {
        this.saveConfig();
        return "success";
    }

    public String doInput() {
        this.loadConfig();
        return "input";
    }

    public String execute() {
        this.loadConfig();
        return "success";
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getHelpUrl() {
        return this.helpUrl;
    }

    public void setHelpUrl(String helpUrl) {
        this.helpUrl = helpUrl;
    }

    public boolean isRssEnabled() {
        return this.rssEnabled;
    }

    public void setRssEnabled(boolean rssEnabled) {
        this.rssEnabled = rssEnabled;
    }

    public boolean isAnonEnabled() {
        return this.anonEnabled;
    }

    public void setAnonEnabled(boolean anonEnabled) {
        this.anonEnabled = anonEnabled;
    }

    public boolean isSignupEnabled() {
        return this.signupEnabled;
    }

    public void setSignupEnabled(boolean signupEnabled) {
        this.signupEnabled = signupEnabled;
    }

    public Integer getScmPollingInterval() {
        return this.scmPollingInterval;
    }

    public void setScmPollingInterval(Integer scmPollingInterval) {
        this.scmPollingInterval = scmPollingInterval;
    }

    public boolean isRecipeTimeoutEnabled() {
        return this.recipeTimeoutEnabled;
    }

    public void setRecipeTimeoutEnabled(boolean recipeTimeoutEnabled) {
        this.recipeTimeoutEnabled = recipeTimeoutEnabled;
    }

    public Long getRecipeTimeout() {
        return this.recipeTimeout;
    }

    public void setRecipeTimeout(Long recipeTimeout) {
        this.recipeTimeout = recipeTimeout;
    }

    private void resetConfig() {
        MasterConfiguration config = this.configurationManager.getAppConfig();
        config.setBaseUrl(null);
        config.setHelpUrl(null);
        config.setRssEnabled(null);
        config.setAnonymousAccessEnabled(null);
        config.setAnonymousSignupEnabled(null);
        config.setScmPollingInterval(null);
        config.setUnsatisfiableRecipeTimeout(null);
        this.postChange(config);
    }

    private void saveConfig() {
        MasterConfiguration config = this.configurationManager.getAppConfig();
        config.setBaseUrl(this.baseUrl);
        config.setHelpUrl(this.helpUrl);
        config.setRssEnabled(this.rssEnabled);
        config.setAnonymousAccessEnabled(this.anonEnabled);
        config.setAnonymousSignupEnabled(this.signupEnabled);
        config.setScmPollingInterval(this.scmPollingInterval);
        if (this.recipeTimeoutEnabled) {
            config.setUnsatisfiableRecipeTimeout(this.recipeTimeout);
        } else {
            config.setUnsatisfiableRecipeTimeout(-1L);
        }
        this.postChange(config);
    }

    private void postChange(MasterConfiguration config) {
        long timeout = config.getUnsatisfiableRecipeTimeout();
        if (timeout > 0L) {
            timeout *= 60000L;
        }
        this.recipeQueue.setUnsatisfiableTimeout(timeout);
        this.guestAccessManager.init();
    }

    private void loadConfig() {
        MasterConfiguration config = this.configurationManager.getAppConfig();
        this.baseUrl = config.getBaseUrl();
        this.helpUrl = config.getHelpUrl();
        this.rssEnabled = config.getRssEnabled();
        this.anonEnabled = config.getAnonymousAccessEnabled();
        this.signupEnabled = config.getAnonymousSignupEnabled();
        this.scmPollingInterval = config.getScmPollingInterval();
        long timeout = config.getUnsatisfiableRecipeTimeout();
        if (timeout >= 0L) {
            this.recipeTimeout = timeout;
            this.recipeTimeoutEnabled = true;
        } else {
            this.recipeTimeout = 15L;
            this.recipeTimeoutEnabled = false;
        }
    }

    public void validate() {
        if (this.recipeTimeoutEnabled) {
            if (this.recipeTimeout == null) {
                this.addFieldError("recipeTimeout", this.getText("recipe.queue.timeout.required"));
            } else if (this.recipeTimeout < 0L) {
                this.addFieldError("recipeTimeout", this.getText("recipe.queue.timeout.invalid"));
            }
        }
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public void setGuestAccessManager(GuestAccessManager guestAccessManager) {
        this.guestAccessManager = guestAccessManager;
    }

    public void setRecipeQueue(ThreadedRecipeQueue recipeQueue) {
        this.recipeQueue = recipeQueue;
    }
}

