/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.core.FileLoadException;
import com.zutubi.pulse.core.model.ResourceProperty;
import com.zutubi.pulse.web.admin.ResourceActionSupport;

public class EditPropertyAction
extends ResourceActionSupport {
    private String name;
    private String newName;
    private String newValue;
    private boolean newAddToEnvironment = false;
    private boolean newAddToPath = false;
    private boolean newResolveVariables = false;
    private ResourceProperty property;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResourceProperty getProperty() {
        return this.property;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    public String getNewValue() {
        return this.newValue;
    }

    public void setNewValue(String newValue) {
        this.newValue = newValue;
    }

    public boolean getNewAddToEnvironment() {
        return this.newAddToEnvironment;
    }

    public void setNewAddToEnvironment(boolean newAddToEnvironment) {
        this.newAddToEnvironment = newAddToEnvironment;
    }

    public boolean getNewAddToPath() {
        return this.newAddToPath;
    }

    public void setNewAddToPath(boolean newAddToPath) {
        this.newAddToPath = newAddToPath;
    }

    public boolean getNewResolveVariables() {
        return this.newResolveVariables;
    }

    public void setNewResolveVariables(boolean newResolveVariables) {
        this.newResolveVariables = newResolveVariables;
    }

    private void lookupProperty() {
        this.lookupResource();
        if (this.hasErrors()) {
            return;
        }
        this.lookupVersion();
        if (this.hasErrors()) {
            return;
        }
        this.property = this.version == null ? this.resource.getProperty(this.name) : this.version.getProperty(this.name);
        if (this.property == null) {
            this.addActionError("Unknown property [" + this.name + "]");
        }
    }

    public String doInput() {
        this.lookupProperty();
        if (this.hasErrors()) {
            return "error";
        }
        this.newName = this.property.getName();
        this.newValue = this.property.getValue();
        this.newAddToEnvironment = this.property.getAddToEnvironment();
        this.newAddToPath = this.property.getAddToPath();
        this.newResolveVariables = this.property.getResolveVariables();
        return "input";
    }

    public void validate() {
        this.lookupProperty();
        if (this.hasErrors()) {
            return;
        }
        if (!TextUtils.stringSet((String)this.newName)) {
            this.addFieldError("newName", "name is required");
            return;
        }
        if (!this.property.getName().equals(this.newName)) {
            if (this.version == null) {
                if (this.resource.hasProperty(this.newName)) {
                    this.addFieldError("newName", "this resource already contains a property with name '" + this.newName + "'");
                }
            } else if (this.version.hasProperty(this.newName)) {
                this.addFieldError("newName", "this version already contains a property with name '" + this.newName + "'");
            }
        }
    }

    public String execute() {
        ResourceProperty newProperty = new ResourceProperty(this.newName, this.newValue, this.newAddToEnvironment, this.newAddToPath, this.newResolveVariables);
        try {
            if (this.version == null) {
                this.resource.deleteProperty(this.name);
                this.resource.addProperty(newProperty);
            } else {
                this.version.deleteProperty(this.name);
                this.version.addProperty(newProperty);
            }
            this.getResourceManager().save(this.resource);
        }
        catch (FileLoadException fileLoadException) {
            // empty catch block
        }
        return "success";
    }
}

