/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin;

import com.opensymphony.xwork.Validateable;
import com.zutubi.pulse.committransformers.CustomCommitMessageTransformer;
import com.zutubi.pulse.committransformers.CustomHandler;
import com.zutubi.pulse.committransformers.JiraCommitMessageTransformer;
import com.zutubi.pulse.committransformers.JiraHandler;
import com.zutubi.pulse.committransformers.LinkCommitMessageTransformer;
import com.zutubi.pulse.committransformers.LinkHandler;
import com.zutubi.pulse.model.CommitMessageTransformer;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.web.user.contact.FormAction;

public class EditCommitMessageTransformerAction
extends FormAction
implements Validateable {
    private long id;
    private long projectId;
    private String name;

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(long projectId) {
        this.projectId = projectId;
    }

    public Project getProject() {
        return this.projectManager.getProject(this.projectId);
    }

    public void validate() {
        if (this.hasErrors()) {
            return;
        }
        CommitMessageTransformer t = this.commitMessageTransformerManager.getByName(this.name);
        if (t != null && t.getId() != this.getId()) {
            this.addFieldError("newName", "A commit message link with name '" + this.name + "' already exists");
        }
    }

    public Object doLoad() {
        CommitMessageTransformer transformer = this.commitMessageTransformerManager.getById(this.getId());
        if (transformer instanceof LinkCommitMessageTransformer) {
            LinkHandler handler = new LinkHandler();
            handler.setName(transformer.getName());
            handler.setExpression(((LinkCommitMessageTransformer)transformer).getExpression());
            handler.setLink(((LinkCommitMessageTransformer)transformer).getLink());
            return handler;
        }
        if (transformer instanceof JiraCommitMessageTransformer) {
            JiraHandler handler = new JiraHandler();
            handler.setName(transformer.getName());
            handler.setUrl(((JiraCommitMessageTransformer)transformer).getUrl());
            return handler;
        }
        if (transformer instanceof CustomCommitMessageTransformer) {
            CustomHandler handler = new CustomHandler();
            handler.setName(transformer.getName());
            handler.setExpression(((CustomCommitMessageTransformer)transformer).getExpression());
            handler.setReplacement(((CustomCommitMessageTransformer)transformer).getReplacement());
            return handler;
        }
        return null;
    }

    public void doSave(Object obj) {
        CommitMessageTransformer transformer = this.commitMessageTransformerManager.getById(this.getId());
        if (obj instanceof LinkHandler) {
            LinkHandler handler = (LinkHandler)obj;
            LinkCommitMessageTransformer standardTransformer = (LinkCommitMessageTransformer)transformer;
            standardTransformer.setName(handler.getName());
            standardTransformer.setExpression(handler.getExpression());
            standardTransformer.setLink(handler.getLink());
            this.commitMessageTransformerManager.save(standardTransformer);
        } else if (obj instanceof JiraHandler) {
            JiraHandler handler = (JiraHandler)obj;
            JiraCommitMessageTransformer jiraTransformer = (JiraCommitMessageTransformer)transformer;
            jiraTransformer.setName(handler.getName());
            jiraTransformer.setUrl(handler.getUrl());
            this.commitMessageTransformerManager.save(jiraTransformer);
        } else if (obj instanceof CustomHandler) {
            CustomHandler handler = (CustomHandler)obj;
            CustomCommitMessageTransformer customTransformer = (CustomCommitMessageTransformer)transformer;
            customTransformer.setName(handler.getName());
            customTransformer.setExpression(handler.getExpression());
            customTransformer.setReplacement(handler.getReplacement());
            this.commitMessageTransformerManager.save(customTransformer);
        }
    }
}

