/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web.admin;

import com.opensymphony.xwork.Validateable;
import com.zutubi.pulse.SlaveProxyFactory;
import com.zutubi.pulse.core.model.Resource;
import com.zutubi.pulse.model.ResourceManager;
import com.zutubi.pulse.model.Slave;
import com.zutubi.pulse.model.SlaveManager;
import com.zutubi.pulse.resources.AntResourceConstructor;
import com.zutubi.pulse.resources.JavaResourceConstructor;
import com.zutubi.pulse.resources.Maven2ResourceConstructor;
import com.zutubi.pulse.resources.MavenResourceConstructor;
import com.zutubi.pulse.resources.ResourceConstructor;
import com.zutubi.pulse.services.SlaveService;
import com.zutubi.pulse.web.wizard.BaseWizard;
import com.zutubi.pulse.web.wizard.BaseWizardState;
import com.zutubi.pulse.web.wizard.Wizard;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.TreeMap;

public class AddResourceWizard
extends BaseWizard {
    private long agentId = -1L;
    private Slave slave;
    private Select select = new Select(this, "select");
    private ResourceManager resourceManager;
    private SlaveManager slaveManager;
    private SlaveProxyFactory slaveProxyFactory;
    private Custom custom;

    public AddResourceWizard() {
        this.addInitialState(this.select);
        this.addState(new Directory(this, "ant", (ResourceConstructor)new AntResourceConstructor()));
        this.addState(new Directory(this, "java", (ResourceConstructor)new JavaResourceConstructor()));
        this.addState(new Directory(this, "maven", (ResourceConstructor)new MavenResourceConstructor()));
        this.addState(new Directory(this, "maven2", (ResourceConstructor)new Maven2ResourceConstructor()));
        this.custom = new Custom(this, "custom");
        this.addState(this.custom);
    }

    public void initialise() {
        super.initialise();
    }

    public void process() {
        Resource resource;
        super.process();
        if (this.select.getType().equals("custom")) {
            resource = new Resource(this.custom.getName());
        } else {
            Directory d = (Directory)this.getState(this.select.getType());
            resource = this.createResource(d.getConstructor(), d.getDir());
        }
        if (resource != null) {
            this.resourceManager.addResource(this.getSlave(), resource);
        }
    }

    public long getAgentId() {
        return this.agentId;
    }

    public void setAgentId(long agentId) {
        this.agentId = agentId;
    }

    public Slave getSlave() {
        return this.slaveManager.getSlave(this.agentId);
    }

    protected boolean isResourceHome(ResourceConstructor c, String path) {
        try {
            if (this.agentId != -1L) {
                return this.slaveProxyFactory.createProxy(this.getSlave()).isResourceHome(c, path);
            }
            return c.isResourceHome(path);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return false;
        }
    }

    protected Resource createResource(ResourceConstructor c, String path) {
        try {
            if (this.agentId != -1L) {
                Slave slave = this.slaveManager.getSlave(this.agentId);
                SlaveService proxy = this.slaveProxyFactory.createProxy(slave);
                return proxy.createResource(c, path);
            }
            return c.createResource(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void setSlaveManager(SlaveManager slaveManager) {
        this.slaveManager = slaveManager;
    }

    public void setSlaveProxyFactory(SlaveProxyFactory slaveProxyFactory) {
        this.slaveProxyFactory = slaveProxyFactory;
    }

    private class Custom
    extends BaseWizardState
    implements Validateable {
        private String name;

        public Custom(Wizard wizard, String name) {
            super(wizard, name);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getNextStateName() {
            return "success";
        }

        public void validate() {
            if (this.hasErrors()) {
                return;
            }
            Slave slave = AddResourceWizard.this.getSlave();
            if (AddResourceWizard.this.resourceManager.findBySlaveAndName(slave, this.name) != null) {
                this.addFieldError("name", String.format("A resource with name '%s' already exists.", this.name));
            }
        }
    }

    private class Directory
    extends BaseWizardState
    implements Validateable {
        private String dir;
        private ResourceConstructor constructor;

        public Directory(Wizard wizard, String name, ResourceConstructor constructor) {
            super(wizard, name);
            this.constructor = constructor;
        }

        public String getNextStateName() {
            return "success";
        }

        public void setDir(String dir) {
            this.dir = dir;
        }

        public String getDir() {
            return this.dir;
        }

        public void validate() {
            if (this.hasErrors()) {
                return;
            }
            if (this.dir != null) {
                this.dir = this.dir.trim();
            }
            if (!AddResourceWizard.this.isResourceHome(this.constructor, this.dir)) {
                this.addFieldError("dir", "The selected directory is not recognised as a base directory for this resource type.");
            }
        }

        public ResourceConstructor getConstructor() {
            return this.constructor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Select
    extends BaseWizardState {
        private Map<String, String> types;
        private String type;

        public Select(Wizard wizard, String name) {
            super(wizard, name);
        }

        @Override
        public String getNextStateName() {
            return this.getType();
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public Map<String, String> getTypes() {
            if (this.types == null) {
                this.types = new TreeMap<String, String>();
                this.types.put("ant", "ant");
                this.types.put("custom", "custom");
                this.types.put("java", "java");
                this.types.put("maven", "maven");
                this.types.put("maven2", "maven2");
            }
            return this.types;
        }
    }
}

