/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web;

import com.opensymphony.util.TextUtils;
import com.opensymphony.webwork.dispatcher.multipart.MultiPartRequestWrapper;
import com.opensymphony.xwork.ActionContext;
import com.zutubi.pulse.MasterBuildPaths;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.model.User;
import com.zutubi.pulse.model.UserManager;
import com.zutubi.pulse.personal.PatchArchive;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.web.ActionSupport;
import java.io.File;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.AccessDeniedException;

public class PersonalBuildAction
extends ActionSupport {
    private static final Logger LOG = Logger.getLogger(PersonalBuildAction.class);
    private String project;
    private String specification;
    private String version;
    private long number;
    private String errorMessage;
    private UserManager userManager;
    private MasterConfigurationManager configurationManager;

    public void setProject(String project) {
        this.project = project;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public long getNumber() {
        return this.number;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String execute() {
        File patchFile;
        ActionContext ac = ActionContext.getContext();
        HttpServletRequest request = (HttpServletRequest)ac.get((Object)"com.opensymphony.xwork.dispatcher.HttpServletRequest");
        User user = null;
        Object principle = this.getPrinciple();
        if (principle != null) {
            user = this.userManager.getUser((String)principle);
        }
        if (user == null) {
            this.errorMessage = "Unable to determine user";
            return "error";
        }
        if (!this.userManager.getPrinciple(user).hasAuthority("ROLE_PERSONAL")) {
            throw new AccessDeniedException("User does not have authority to submit personal build requests.");
        }
        if (!(request instanceof MultiPartRequestWrapper)) {
            this.errorMessage = "Invalid request: expecting multipart POST";
            return "error";
        }
        MultiPartRequestWrapper mpr = (MultiPartRequestWrapper)request;
        File[] files = mpr.getFiles("patch.zip");
        if (files == null || files.length == 0 || files[0] == null) {
            this.errorMessage = "POST does not contain required file parameter 'patch.zip'";
            return "error";
        }
        File uploadedPatch = files[0];
        if (!uploadedPatch.exists()) {
            this.errorMessage = "Uploaded patch file '" + uploadedPatch.getAbsolutePath() + "' does not exist";
            return "error";
        }
        if (!uploadedPatch.isFile()) {
            this.errorMessage = "Uploaded patch file '" + uploadedPatch.getAbsolutePath() + "' is not a regular file";
            return "error";
        }
        Project p = this.projectManager.getProject(this.project);
        if (p == null) {
            this.errorMessage = "Unknown project '" + this.project + "'";
            return "error";
        }
        BuildSpecification spec = TextUtils.stringSet((String)this.specification) ? p.getBuildSpecification(this.specification) : p.getDefaultSpecification();
        if (spec == null) {
            this.errorMessage = "Unknown build specification '" + this.specification + "'";
            return "error";
        }
        this.number = this.userManager.getNextBuildNumber(user);
        MasterBuildPaths paths = new MasterBuildPaths(this.configurationManager);
        File patchDir = paths.getUserPatchDir(user.getId());
        if (!patchDir.isDirectory()) {
            patchDir.mkdirs();
        }
        if ((patchFile = paths.getUserPatchFile(user.getId(), this.number)).exists()) {
            this.errorMessage = "Patch file '" + patchFile.getAbsolutePath() + "' already exists.  Retry the build.";
        }
        PatchArchive archive = null;
        try {
            IOUtils.copyFile((File)uploadedPatch, (File)patchFile);
            uploadedPatch.delete();
            archive = new PatchArchive(patchFile);
            this.projectManager.triggerBuild(this.number, p, spec, user, archive);
        }
        catch (Exception e) {
            LOG.severe((Throwable)e);
            this.errorMessage = e.getClass().getName() + ": " + e.getMessage();
            return "error";
        }
        return "success";
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

