/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.web;

public class PagingSupport {
    private static final int SURROUNDING_PAGES = 10;
    private int totalItems;
    private int itemsPerPage;
    private int startPage;

    public PagingSupport(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
        this.startPage = 0;
    }

    public PagingSupport(int totalPages, int itemsPerPage, int startPage) {
        this.totalItems = totalPages;
        this.itemsPerPage = itemsPerPage;
        this.startPage = startPage;
    }

    public int getTotalItems() {
        return this.totalItems;
    }

    public void setTotalItems(int totalItems) {
        this.totalItems = totalItems;
    }

    public int getItemsPerPage() {
        return this.itemsPerPage;
    }

    public void setItemsPerPage(int itemsPerPage) {
        this.itemsPerPage = itemsPerPage;
    }

    public int getStartPage() {
        return this.startPage;
    }

    public void setStartPage(int startPage) {
        this.startPage = startPage;
    }

    public int getPageCount() {
        return (this.totalItems + this.itemsPerPage - 1) / this.itemsPerPage;
    }

    public int getPageRangeStart() {
        int start;
        int offset = 5;
        if (this.startPage + offset + 1 > this.getPageCount()) {
            offset += this.startPage + offset + 1 - this.getPageCount();
        }
        if ((start = this.startPage - offset) < 0) {
            start = 0;
        }
        return start;
    }

    public int getPageRangeEnd() {
        int end;
        int offset = 5;
        if (this.startPage - offset < 0) {
            offset += offset - this.startPage;
        }
        if ((end = this.startPage + offset) >= this.getPageCount()) {
            end = this.getPageCount() - 1;
        }
        return end;
    }

    public boolean isStartPageValid() {
        return this.startPage == 0 || this.startPage * this.itemsPerPage < this.totalItems;
    }

    public int getStartOffset() {
        return this.startPage * this.itemsPerPage;
    }

    public int getEndOffset() {
        int offset = this.getStartOffset() + this.itemsPerPage;
        if (offset > this.totalItems) {
            offset = this.totalItems;
        }
        return offset;
    }

    public void clampStartPage() {
        if (this.startPage * this.itemsPerPage >= this.totalItems) {
            this.startPage = this.getPageCount() - 1;
        }
        if (this.startPage < 0) {
            this.startPage = 0;
        }
    }
}

