/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.MasterBuildPaths;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.model.RecipeResult;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.BuildResultProvider;
import com.zutubi.pulse.vfs.pulse.RecipeResultProvider;
import com.zutubi.pulse.vfs.pulse.TextMessageFileObject;
import com.zutubi.pulse.vfs.pulse.WorkingCopyFileObject;
import java.io.File;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class WorkingCopyStageFileObject
extends AbstractPulseFileObject
implements RecipeResultProvider {
    private MasterConfigurationManager configurationManager;
    private final String STAGE_FORMAT = "stage :: %s :: %s@%s";
    private final long recipeId;
    private static final String NO_WORKING_COPY_AVAILABLE = "no working copy available";

    public WorkingCopyStageFileObject(FileName name, long recipeId, AbstractFileSystem fs) {
        super(name, fs);
        this.recipeId = recipeId;
    }

    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        String child = fileName.getBaseName();
        if (child.equals(NO_WORKING_COPY_AVAILABLE)) {
            return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(TextMessageFileObject.class, new Class[]{FileName.class, String.class, AbstractFileSystem.class}, new Object[]{fileName, "message", this.pfs}));
        }
        File newBase = new File(this.getWorkingCopyBase(), child);
        return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(WorkingCopyFileObject.class, new Class[]{FileName.class, File.class, AbstractFileSystem.class}, new Object[]{fileName, newBase, this.pfs}));
    }

    protected FileType doGetType() throws Exception {
        return FileType.FOLDER;
    }

    protected String[] doListChildren() throws Exception {
        if (!this.getRecipeResult().completed()) {
            return new String[0];
        }
        File copyBase = this.getWorkingCopyBase();
        if (copyBase.isDirectory()) {
            return copyBase.list();
        }
        return new String[]{NO_WORKING_COPY_AVAILABLE};
    }

    protected File getWorkingCopyBase() throws FileSystemException {
        BuildResultProvider provider = (BuildResultProvider)((Object)this.getAncestor(BuildResultProvider.class));
        if (provider == null) {
            return null;
        }
        BuildResult buildResult = provider.getBuildResult();
        MasterBuildPaths paths = new MasterBuildPaths(this.configurationManager);
        return paths.getBaseDir(buildResult, this.recipeId);
    }

    public String getDisplayName() {
        RecipeResultNode node = this.buildManager.getResultNodeByResultId(this.recipeId);
        return String.format("stage :: %s :: %s@%s", node.getStage(), node.getResult().getRecipeNameSafe(), node.getHostSafe());
    }

    public RecipeResult getRecipeResult() {
        return this.buildManager.getRecipeResult(this.getRecipeResultId());
    }

    public long getRecipeResultId() {
        return this.recipeId;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

