/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.AddressableFileObject;
import com.zutubi.pulse.vfs.pulse.BuildResultProvider;
import com.zutubi.pulse.vfs.pulse.ProjectProvider;
import com.zutubi.pulse.vfs.pulse.RecipeResultProvider;
import com.zutubi.pulse.vfs.pulse.WorkingCopyStageFileObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkingCopyFileObject
extends AbstractPulseFileObject
implements AddressableFileObject {
    private final File base;

    public WorkingCopyFileObject(FileName name, File base, AbstractFileSystem fs) {
        super(name, fs);
        this.base = base;
    }

    @Override
    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        File newBase = new File(this.base, fileName.getBaseName());
        return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(WorkingCopyFileObject.class, new Class[]{FileName.class, File.class, AbstractFileSystem.class}, new Object[]{fileName, newBase, this.pfs}));
    }

    protected FileType doGetType() throws Exception {
        if (this.base.isDirectory()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    @Override
    public List<String> getActions() {
        if (this.base.isFile()) {
            LinkedList<String> actions = new LinkedList<String>();
            actions.add("download");
            return actions;
        }
        return super.getActions();
    }

    protected String[] doListChildren() throws Exception {
        return this.base.list();
    }

    @Override
    protected long doGetContentSize() throws Exception {
        return this.base.length();
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        return new FileInputStream(this.base);
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public String getUrlPath() {
        try {
            return "/file/builds/" + this.getBuildId() + "/wc/" + this.getRecipeId() + "/" + this.getWorkingCopyPath();
        }
        catch (FileSystemException e) {
            e.printStackTrace();
            return "";
        }
    }

    private long getBuildId() throws FileSystemException {
        BuildResultProvider provider = (BuildResultProvider)((Object)this.getAncestor(BuildResultProvider.class));
        return provider.getBuildResultId();
    }

    private long getRecipeId() throws FileSystemException {
        RecipeResultProvider provider = (RecipeResultProvider)((Object)this.getAncestor(RecipeResultProvider.class));
        return provider.getRecipeResultId();
    }

    protected String getWorkingCopyPath() throws FileSystemException {
        AbstractPulseFileObject fo = this.getAncestor(WorkingCopyStageFileObject.class);
        return fo.getName().getRelativeName(this.getName());
    }

    protected boolean doIsReadable() throws Exception {
        try {
            ProjectProvider node = (ProjectProvider)((Object)this.getAncestor(ProjectProvider.class));
            Project project = node.getProject();
            this.projectManager.checkWrite(project);
            return true;
        }
        catch (FileSystemException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

