/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.MasterBuildPaths;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.model.BuildManager;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.PulseFileProvider;
import com.zutubi.pulse.vfs.pulse.RootFileObject;
import java.io.File;
import java.util.Collection;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class PulseFileSystem
extends AbstractFileSystem {
    private ObjectFactory objectFactory;
    private BuildManager buildManager;
    private MasterConfigurationManager configurationManager;

    public PulseFileSystem(FileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) {
        super(rootName, parentLayer, fileSystemOptions);
    }

    protected FileObject createFile(FileName fileName) throws Exception {
        AbstractPulseFileObject newFile;
        String path = fileName.getPath();
        if (path.equals("/")) {
            AbstractPulseFileObject newFile2 = (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(RootFileObject.class, new Class[]{FileName.class, AbstractFileSystem.class}, new Object[]{fileName, this}));
            newFile2.init();
            return newFile2;
        }
        FileName parentFileName = fileName.getParent();
        AbstractPulseFileObject pfo = (AbstractPulseFileObject)this.resolveFile(parentFileName);
        if (pfo != null && (newFile = pfo.createFile(fileName)) != null) {
            newFile.init();
            return newFile;
        }
        throw new FileSystemException(String.format("failed to resolve the requested file: '%s'", fileName.getPath()));
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(PulseFileProvider.CAPABILITIES);
    }

    protected File getBaseDir(Long buildId, Long recipeId) {
        BuildResult result = this.buildManager.getBuildResult(buildId);
        MasterBuildPaths paths = new MasterBuildPaths(this.configurationManager);
        return paths.getBaseDir(result, recipeId);
    }

    public void setBuildManager(BuildManager buildManager) {
        this.buildManager = buildManager;
    }

    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    public MasterConfigurationManager getConfigurationManager() {
        return this.configurationManager;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }
}

