/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.AddressableFileObject;
import com.zutubi.pulse.vfs.pulse.BuildSpecificationsFileObject;
import com.zutubi.pulse.vfs.pulse.BuildsFileObject;
import com.zutubi.pulse.vfs.pulse.LatestBuildFileObject;
import com.zutubi.pulse.vfs.pulse.LatestSuccessfulBuildFileObject;
import com.zutubi.pulse.vfs.pulse.ProjectProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class ProjectFileObject
extends AbstractPulseFileObject
implements ProjectProvider,
AddressableFileObject {
    private static final Map<String, Class> nodesDefinitions = new HashMap<String, Class>();
    private String displayName;
    private long projectId;

    public ProjectFileObject(FileName name, long projectId, AbstractFileSystem fs) {
        super(name, fs);
        nodesDefinitions.put("builds", BuildsFileObject.class);
        nodesDefinitions.put("latest", LatestBuildFileObject.class);
        nodesDefinitions.put("successful", LatestSuccessfulBuildFileObject.class);
        nodesDefinitions.put("latestsuccessful", LatestSuccessfulBuildFileObject.class);
        nodesDefinitions.put("specs", BuildSpecificationsFileObject.class);
        this.projectId = projectId;
    }

    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        String name = fileName.getBaseName();
        if (nodesDefinitions.containsKey(name)) {
            Class clazz = nodesDefinitions.get(name);
            return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(clazz, new Class[]{FileName.class, AbstractFileSystem.class}, new Object[]{fileName, this.pfs}));
        }
        return null;
    }

    protected void doAttach() throws Exception {
        Project project = this.getProject();
        this.displayName = project.getName();
    }

    protected FileType doGetType() throws Exception {
        return FileType.FOLDER;
    }

    protected String[] doListChildren() throws Exception {
        Set<String> children = nodesDefinitions.keySet();
        return children.toArray(new String[children.size()]);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Project getProject() {
        return this.projectManager.getProject(this.projectId);
    }

    public long getProjectId() {
        return this.projectId;
    }

    public boolean isLocal() {
        return true;
    }

    public String getUrlPath() {
        return "/currentBuild.action?id=" + this.getProjectId();
    }
}

