/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.RecipeResult;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.CommandResultProvider;
import com.zutubi.pulse.vfs.pulse.NamedArtifactFileObject;
import com.zutubi.pulse.vfs.pulse.RecipeResultProvider;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class NamedCommandFileObject
extends AbstractPulseFileObject
implements CommandResultProvider {
    private final String commandName;

    public NamedCommandFileObject(FileName name, String commandName, AbstractFileSystem fs) {
        super(name, fs);
        this.commandName = commandName;
    }

    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        String name = fileName.getBaseName();
        return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(NamedArtifactFileObject.class, new Class[]{FileName.class, String.class, AbstractFileSystem.class}, new Object[]{fileName, name, this.pfs}));
    }

    protected FileType doGetType() throws Exception {
        return FileType.FOLDER;
    }

    protected String[] doListChildren() throws Exception {
        return new String[0];
    }

    public CommandResult getCommandResult() throws FileSystemException {
        RecipeResultProvider provider = (RecipeResultProvider)((Object)this.getAncestor(RecipeResultProvider.class));
        if (provider == null) {
            throw new FileSystemException("Missing build stage context.");
        }
        RecipeResult result = provider.getRecipeResult();
        if (result == null) {
            throw new FileSystemException("No build stage results available.");
        }
        CommandResult commandResult = this.buildManager.getCommandResult(result.getId(), this.commandName);
        if (commandResult == null) {
            throw new FileSystemException(String.format("No command result available for '%s'", this.commandName));
        }
        return commandResult;
    }

    public long getCommandResultId() throws FileSystemException {
        return this.getCommandResult().getId();
    }
}

