/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.core.model.CommandResult;
import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.AddressableFileObject;
import com.zutubi.pulse.vfs.pulse.ArtifactProvider;
import com.zutubi.pulse.vfs.pulse.BuildResultProvider;
import com.zutubi.pulse.vfs.pulse.CommandResultProvider;
import com.zutubi.pulse.vfs.pulse.NamedFileArtifactFileObject;
import java.io.File;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class NamedArtifactFileObject
extends AbstractPulseFileObject
implements AddressableFileObject,
ArtifactProvider {
    private final String artifactName;

    public NamedArtifactFileObject(FileName name, String artifactName, AbstractFileSystem fs) {
        super(name, fs);
        this.artifactName = artifactName;
    }

    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        String name = fileName.getBaseName();
        File newFile = new File(this.getArtifactBase(), name);
        return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(NamedFileArtifactFileObject.class, new Class[]{FileName.class, File.class, AbstractFileSystem.class}, new Object[]{fileName, newFile, this.pfs}));
    }

    protected FileType doGetType() throws Exception {
        return FileType.IMAGINARY;
    }

    protected String[] doListChildren() throws Exception {
        return new String[0];
    }

    public boolean isLocal() throws FileSystemException {
        return !this.getArtifact().isLink();
    }

    public String getUrlPath() throws FileSystemException {
        StoredArtifact artifact = this.getArtifact();
        if (artifact == null) {
            throw new FileSystemException(String.format("There is no artifact by name '%s' available.", this.artifactName));
        }
        if (artifact.isLink()) {
            return artifact.getUrl();
        }
        if (artifact.hasIndexFile() && !artifact.isSingleFile()) {
            return "/file/artifacts/" + artifact.getId() + "/" + artifact.findIndexFile();
        }
        return "";
    }

    private File getArtifactBase() throws FileSystemException {
        CommandResult result = this.getCommandResult();
        StoredArtifact artifact = this.getArtifact();
        File outputDir = result.getAbsoluteOutputDir(this.pfs.getConfigurationManager().getDataDirectory());
        return new File(outputDir, artifact.getName());
    }

    protected BuildResult getBuildResult() throws FileSystemException {
        BuildResultProvider provider = (BuildResultProvider)((Object)this.getAncestor(BuildResultProvider.class));
        if (provider == null) {
            throw new FileSystemException("Missing build result context");
        }
        return provider.getBuildResult();
    }

    protected CommandResult getCommandResult() throws FileSystemException {
        CommandResultProvider provider = (CommandResultProvider)((Object)this.getAncestor(CommandResultProvider.class));
        if (provider == null) {
            throw new FileSystemException("Missing command result context");
        }
        return provider.getCommandResult();
    }

    public StoredArtifact getArtifact() throws FileSystemException {
        CommandResult commandResult = this.getCommandResult();
        return this.buildManager.getCommandResultByArtifact(commandResult.getId(), this.artifactName);
    }

    public long getArtifactId() throws FileSystemException {
        return this.getArtifact().getId();
    }
}

