/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.AddressableFileObject;
import com.zutubi.pulse.vfs.pulse.BuildResultProvider;
import com.zutubi.pulse.vfs.pulse.BuildSpecificationProvider;
import com.zutubi.pulse.vfs.pulse.NamedArtifactsFileObject;
import com.zutubi.pulse.vfs.pulse.NamedStageFileObject;
import com.zutubi.pulse.vfs.pulse.ProjectProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class LatestBuildFileObject
extends AbstractPulseFileObject
implements AddressableFileObject,
BuildResultProvider {
    private static final Map<String, Class> nodesDefinitions = new HashMap<String, Class>();
    private static final Logger LOG = Logger.getLogger(LatestBuildFileObject.class);

    public LatestBuildFileObject(FileName name, AbstractFileSystem fs) {
        super(name, fs);
        nodesDefinitions.put("artifacts", NamedArtifactsFileObject.class);
    }

    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        String name = fileName.getBaseName();
        if (nodesDefinitions.containsKey(name)) {
            Class clazz = nodesDefinitions.get(name);
            return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(clazz, new Class[]{FileName.class, AbstractFileSystem.class}, new Object[]{fileName, this.pfs}));
        }
        return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(NamedStageFileObject.class, new Class[]{FileName.class, String.class, AbstractFileSystem.class}, new Object[]{fileName, name, this.pfs}));
    }

    protected FileType doGetType() throws Exception {
        return FileType.IMAGINARY;
    }

    protected String[] doListChildren() throws Exception {
        Set<String> rootPaths = nodesDefinitions.keySet();
        return rootPaths.toArray(new String[rootPaths.size()]);
    }

    public boolean isLocal() {
        return true;
    }

    public String getUrlPath() {
        return "/viewBuild.action?id=" + this.getBuildResultId();
    }

    public BuildResult getBuildResult() {
        try {
            ProjectProvider provider = (ProjectProvider)((Object)this.getAncestor(ProjectProvider.class));
            if (provider != null) {
                Project project = provider.getProject();
                BuildSpecificationProvider buildSpecProvider = (BuildSpecificationProvider)((Object)this.getAncestor(BuildSpecificationProvider.class));
                if (buildSpecProvider != null) {
                    return this.buildManager.getLatestBuildResult(buildSpecProvider.getBuildSpecification());
                }
                return this.buildManager.getLatestBuildResult(project);
            }
            return this.buildManager.getLatestBuildResult();
        }
        catch (FileSystemException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    public long getBuildResultId() {
        BuildResult result = this.getBuildResult();
        if (result != null) {
            return result.getId();
        }
        return -1L;
    }
}

