/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.core.model.StoredArtifact;
import com.zutubi.pulse.core.model.StoredFileArtifact;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.AddressableFileObject;
import com.zutubi.pulse.vfs.pulse.ArtifactProvider;
import com.zutubi.pulse.vfs.pulse.FileArtifactProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileArtifactFileObject
extends AbstractPulseFileObject
implements AddressableFileObject,
FileArtifactProvider {
    private static final Logger LOG = Logger.getLogger(FileArtifactFileObject.class);
    private File base;
    private Boolean canDecorate;

    public FileArtifactFileObject(FileName name, File base, AbstractFileSystem fs) {
        super(name, fs);
        this.base = base;
    }

    private boolean canDecorate() {
        if (this.canDecorate == null) {
            this.canDecorate = false;
            try {
                StoredFileArtifact artifact;
                if (this.base.isFile() && (artifact = this.getFileArtifact()) != null) {
                    this.canDecorate = this.buildManager.canDecorateArtifact(artifact.getId());
                }
            }
            catch (FileSystemException e) {
                LOG.error((Throwable)e);
            }
        }
        return this.canDecorate;
    }

    @Override
    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        File newBase = new File(this.base, fileName.getBaseName());
        return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(FileArtifactFileObject.class, new Class[]{FileName.class, File.class, AbstractFileSystem.class}, new Object[]{fileName, newBase, this.pfs}));
    }

    protected FileType doGetType() throws Exception {
        if (this.base.isDirectory()) {
            return FileType.FOLDER;
        }
        return FileType.FILE;
    }

    protected String[] doListChildren() throws Exception {
        return this.base.list();
    }

    @Override
    protected long doGetContentSize() throws Exception {
        return this.base.length();
    }

    @Override
    protected InputStream doGetInputStream() throws Exception {
        return new FileInputStream(this.base);
    }

    @Override
    public File toFile() {
        return this.base;
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public String getUrlPath() {
        try {
            return "/file/artifacts/" + this.getArtifact().getId() + "/" + this.getArtifactPath();
        }
        catch (FileSystemException e) {
            LOG.warning((Throwable)e);
            return "";
        }
    }

    @Override
    public List<String> getActions() {
        LinkedList<String> actions = new LinkedList<String>();
        if (this.base.isFile()) {
            actions.add("download");
        }
        if (this.canDecorate()) {
            actions.add("decorate");
        }
        return actions;
    }

    @Override
    public StoredFileArtifact getFileArtifact() throws FileSystemException {
        return this.getArtifact().findFileBase(this.getArtifactPath());
    }

    @Override
    public File getFile() {
        return this.base;
    }

    @Override
    public long getFileArtifactId() throws FileSystemException {
        return this.getFileArtifact().getId();
    }

    protected StoredArtifact getArtifact() throws FileSystemException {
        return ((ArtifactProvider)((Object)this.getAncestor(ArtifactProvider.class))).getArtifact();
    }

    protected String getArtifactPath() throws FileSystemException {
        AbstractPulseFileObject fo = this.getAncestor(ArtifactProvider.class);
        return fo.getName().getRelativeName(this.getName());
    }
}

