/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.model.Project;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.BuildSpecificationFileObject;
import com.zutubi.pulse.vfs.pulse.ProjectProvider;
import java.util.LinkedList;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class BuildSpecificationsFileObject
extends AbstractPulseFileObject {
    public BuildSpecificationsFileObject(FileName name, AbstractFileSystem fs) {
        super(name, fs);
    }

    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        long id = this.convertToSpecificationId(fileName.getBaseName());
        return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(BuildSpecificationFileObject.class, new Class[]{FileName.class, Long.TYPE, AbstractFileSystem.class}, new Object[]{fileName, id, this.pfs}));
    }

    private long convertToSpecificationId(String baseName) {
        try {
            return Long.parseLong(baseName);
        }
        catch (NumberFormatException e) {
            try {
                Project project = this.getProject();
                BuildSpecification spec = project.getBuildSpecification(baseName);
                if (spec != null) {
                    return spec.getId();
                }
                return -1L;
            }
            catch (FileSystemException e1) {
                return -1L;
            }
        }
    }

    private Project getProject() throws FileSystemException {
        ProjectProvider provider = (ProjectProvider)((Object)this.getAncestor(ProjectProvider.class));
        return provider.getProject();
    }

    protected FileType doGetType() throws Exception {
        return FileType.FOLDER;
    }

    protected String[] doListChildren() throws Exception {
        LinkedList<String> children = new LinkedList<String>();
        Project project = this.getProject();
        for (BuildSpecification spec : project.getBuildSpecifications()) {
            children.add(spec.getName());
        }
        return children.toArray(new String[children.size()]);
    }
}

