/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.pulse;

import com.zutubi.pulse.model.BuildResult;
import com.zutubi.pulse.model.RecipeResultNode;
import com.zutubi.pulse.vfs.pulse.AbstractPulseFileObject;
import com.zutubi.pulse.vfs.pulse.AddressableFileObject;
import com.zutubi.pulse.vfs.pulse.ArtifactStageFileObject;
import com.zutubi.pulse.vfs.pulse.BuildResultProvider;
import java.util.LinkedList;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class ArtifactsContextFileObject
extends AbstractPulseFileObject
implements AddressableFileObject {
    public ArtifactsContextFileObject(FileName name, AbstractFileSystem fs) {
        super(name, fs);
    }

    public AbstractPulseFileObject createFile(FileName fileName) throws Exception {
        long recipeId = Long.parseLong(fileName.getBaseName());
        return (AbstractPulseFileObject)((Object)this.objectFactory.buildBean(ArtifactStageFileObject.class, new Class[]{FileName.class, Long.TYPE, AbstractFileSystem.class}, new Object[]{fileName, recipeId, this.pfs}));
    }

    protected FileType doGetType() throws Exception {
        return FileType.FOLDER;
    }

    protected void doAttach() throws Exception {
        this.childrenChanged(null, null);
    }

    protected String[] doListChildren() throws Exception {
        LinkedList<String> results = new LinkedList<String>();
        BuildResult result = this.getBuildResult();
        if (result != null) {
            RecipeResultNode node = this.getBuildResult().getRoot();
            for (RecipeResultNode child : node.getChildren()) {
                results.add(Long.toString(child.getResult().getId()));
            }
            return results.toArray(new String[results.size()]);
        }
        return new String[0];
    }

    protected BuildResult getBuildResult() throws FileSystemException {
        BuildResultProvider provider = (BuildResultProvider)((Object)this.getAncestor(BuildResultProvider.class));
        if (provider != null) {
            return provider.getBuildResult();
        }
        return null;
    }

    protected long getBuildResultId() {
        try {
            BuildResultProvider provider = (BuildResultProvider)((Object)this.getAncestor(BuildResultProvider.class));
            if (provider != null) {
                return provider.getBuildResultId();
            }
            return -1L;
        }
        catch (FileSystemException e) {
            return -1L;
        }
    }

    public boolean isLocal() {
        return true;
    }

    public String getUrlPath() {
        return "/viewBuildArtifacts.action?id=" + this.getBuildResultId();
    }
}

