/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.agent;

import com.caucho.hessian.client.HessianRuntimeException;
import com.zutubi.pulse.SlaveProxyFactory;
import com.zutubi.pulse.SystemInfo;
import com.zutubi.pulse.model.Slave;
import com.zutubi.pulse.model.SlaveManager;
import com.zutubi.pulse.services.ServiceTokenManager;
import com.zutubi.pulse.services.SlaveService;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.vfs.agent.AgentFileName;
import com.zutubi.pulse.vfs.agent.AgentFileObject;
import com.zutubi.pulse.vfs.agent.AgentFileProvider;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractFileSystem;

public class AgentFileSystem
extends AbstractFileSystem {
    private static final Logger LOG = Logger.getLogger(AgentFileSystem.class);
    private SlaveManager slaveManager;
    private SlaveProxyFactory proxyFactory;
    private ServiceTokenManager serviceTokenManager;
    private List<FileName> rootNames;
    private String agent;
    private String osName;

    public AgentFileSystem(FileName rootName, FileObject parentLayer, FileSystemOptions fileSystemOptions) {
        super(rootName, parentLayer, fileSystemOptions);
        this.agent = ((AgentFileName)rootName).getAddress();
    }

    public void init() throws FileSystemException {
        super.init();
        SlaveService slaveService = this.getProxy();
        String token = this.getToken();
        try {
            this.getOs(slaveService, token);
            this.loadFileSystemRoots(slaveService, token);
        }
        catch (HessianRuntimeException e) {
            LOG.warning((Throwable)e);
            throw new FileSystemException((Throwable)e);
        }
    }

    protected FileObject createFile(FileName name) throws Exception {
        return new AgentFileObject(name, this);
    }

    protected void addCapabilities(Collection caps) {
        caps.addAll(AgentFileProvider.CAPABILITIES);
    }

    private void getOs(SlaveService slaveService, String token) {
        SystemInfo info = slaveService.getSystemInfo(token);
        this.osName = (String)info.getSystemProperties().get("os.name");
    }

    private void loadFileSystemRoots(SlaveService slaveService, String token) throws FileSystemException {
        this.rootNames = new LinkedList<FileName>();
        for (String root : slaveService.listRoots(token)) {
            this.rootNames.add(this.getFileSystemManager().resolveName(this.getRootName(), root));
        }
    }

    protected String[] getRoots() {
        LinkedList<String> roots = new LinkedList<String>();
        for (FileName rootName : this.rootNames) {
            roots.add(rootName.getPath());
        }
        return roots.toArray(new String[roots.size()]);
    }

    protected boolean isRoot(String name) {
        try {
            FileName rootName = this.getFileSystemManager().resolveName(this.getRootName(), name);
            if (this.rootNames.contains(rootName)) {
                return true;
            }
        }
        catch (FileSystemException e) {
            e.printStackTrace();
        }
        return false;
    }

    protected SlaveService getProxy() throws FileSystemException {
        try {
            Slave slave = this.slaveManager.getSlave(Long.valueOf(this.agent));
            return this.proxyFactory.createProxy(slave);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            throw new FileSystemException((Throwable)e);
        }
    }

    protected String getToken() {
        return this.serviceTokenManager.getToken();
    }

    public boolean isWindows() {
        return this.osName != null && this.osName.toLowerCase().startsWith("win");
    }

    public void setSlaveManager(SlaveManager slaveManager) {
        this.slaveManager = slaveManager;
    }

    public void setProxyFactory(SlaveProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public void setServiceTokenManager(ServiceTokenManager serviceTokenManager) {
        this.serviceTokenManager = serviceTokenManager;
    }
}

