/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.agent;

import com.zutubi.pulse.SlaveProxyFactory;
import com.zutubi.pulse.model.SlaveManager;
import com.zutubi.pulse.services.ServiceTokenManager;
import com.zutubi.pulse.vfs.agent.AgentFileNameParser;
import com.zutubi.pulse.vfs.agent.AgentFileSystem;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs.provider.FileNameParser;

public class AgentFileProvider
extends AbstractOriginatingFileProvider {
    private SlaveManager slaveManager;
    private SlaveProxyFactory proxyFactory;
    private ServiceTokenManager serviceTokenManager;
    static final Collection CAPABILITIES = Collections.unmodifiableCollection(Arrays.asList(Capability.GET_TYPE, Capability.READ_CONTENT, Capability.URI, Capability.GET_LAST_MODIFIED));

    public AgentFileProvider() {
        this.setFileNameParser((FileNameParser)new AgentFileNameParser());
    }

    protected FileSystem doCreateFileSystem(FileName rootName, FileSystemOptions options) throws FileSystemException {
        AgentFileSystem fileSystem = new AgentFileSystem(rootName, null, options);
        fileSystem.setProxyFactory(this.proxyFactory);
        fileSystem.setSlaveManager(this.slaveManager);
        fileSystem.setServiceTokenManager(this.serviceTokenManager);
        return fileSystem;
    }

    public Collection getCapabilities() {
        return CAPABILITIES;
    }

    public void setSlaveManager(SlaveManager slaveManager) {
        this.slaveManager = slaveManager;
    }

    public void setSlaveProxyFactory(SlaveProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public void setServiceTokenManager(ServiceTokenManager serviceTokenManager) {
        this.serviceTokenManager = serviceTokenManager;
    }
}

