/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs.agent;

import com.caucho.hessian.client.HessianRuntimeException;
import com.zutubi.pulse.filesystem.FileInfo;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.vfs.agent.AgentFileSystem;
import java.io.InputStream;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.UriParser;

public class AgentFileObject
extends AbstractFileObject {
    private static final Logger LOG = Logger.getLogger(AgentFileObject.class);
    private AgentFileSystem fs;

    public AgentFileObject(FileName name, AgentFileSystem fs) {
        super(name, (AbstractFileSystem)fs);
        this.fs = fs;
    }

    protected FileType doGetType() throws Exception {
        FileInfo file = this.getFileInfo();
        if (file.isFile()) {
            return FileType.FILE;
        }
        if (file.isDirectory()) {
            return FileType.FOLDER;
        }
        return FileType.IMAGINARY;
    }

    protected String[] doListChildren() throws Exception {
        String path = this.getName().getPath();
        if (this.fs.isWindows() && path.equals("/")) {
            return this.fs.getRoots();
        }
        FileInfo info = this.getFileInfo();
        return UriParser.encode((String[])info.list());
    }

    protected long doGetContentSize() throws Exception {
        return 0L;
    }

    protected InputStream doGetInputStream() throws Exception {
        return null;
    }

    protected FileInfo getFileInfo() throws FileSystemException {
        String path = this.getName().getPath();
        try {
            if (this.fs.isWindows() && this.fs.isRoot(path)) {
                return this.fs.getProxy().getFileInfo(this.fs.getToken(), path + "/");
            }
            return this.fs.getProxy().getFileInfo(this.fs.getToken(), path);
        }
        catch (HessianRuntimeException e) {
            LOG.warning((Throwable)e);
            throw new FileSystemException((Throwable)e);
        }
    }
}

