/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.vfs;

import com.zutubi.pulse.SlaveProxyFactory;
import com.zutubi.pulse.core.ObjectFactory;
import com.zutubi.pulse.model.SlaveManager;
import com.zutubi.pulse.services.ServiceTokenManager;
import com.zutubi.pulse.util.logging.Logger;
import com.zutubi.pulse.vfs.agent.AgentFileProvider;
import com.zutubi.pulse.vfs.local.DefaultLocalFileProvider;
import com.zutubi.pulse.vfs.pulse.PulseFileProvider;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.impl.DefaultFileSystemManager;
import org.apache.commons.vfs.provider.FileProvider;
import org.apache.commons.vfs.provider.ram.RamFileProvider;
import org.springframework.beans.factory.FactoryBean;

public class VfsManagerFactoryBean
implements FactoryBean {
    private static final Logger LOG = Logger.getLogger(VfsManagerFactoryBean.class);
    private ObjectFactory objectFactory;
    private SlaveManager slaveManager;
    private SlaveProxyFactory proxyFactory;
    private ServiceTokenManager serviceTokenManager;
    private DefaultFileSystemManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject() throws Exception {
        if (this.instance == null) {
            VfsManagerFactoryBean vfsManagerFactoryBean = this;
            synchronized (vfsManagerFactoryBean) {
                if (this.instance == null) {
                    this.instance = new DefaultFileSystemManager();
                    this.instance.addProvider("local", (FileProvider)new DefaultLocalFileProvider());
                    this.instance.addProvider("ram", (FileProvider)new RamFileProvider());
                    AgentFileProvider agentFileProviderfileProvider = new AgentFileProvider();
                    agentFileProviderfileProvider.setSlaveManager(this.slaveManager);
                    agentFileProviderfileProvider.setSlaveProxyFactory(this.proxyFactory);
                    agentFileProviderfileProvider.setServiceTokenManager(this.serviceTokenManager);
                    this.instance.addProvider("agent", (FileProvider)agentFileProviderfileProvider);
                    PulseFileProvider pulseFileProvider = (PulseFileProvider)((Object)this.objectFactory.buildBean(PulseFileProvider.class));
                    this.instance.addProvider("pulse", (FileProvider)pulseFileProvider);
                    this.instance.init();
                }
            }
        }
        return this.instance;
    }

    public Class getObjectType() {
        return FileSystemManager.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void shutdown() {
        if (this.instance != null) {
            this.instance.close();
        }
    }

    public void setSlaveProxyFactory(SlaveProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory;
    }

    public void setSlaveManager(SlaveManager slaveManager) {
        this.slaveManager = slaveManager;
    }

    public void setServiceTokenManager(ServiceTokenManager serviceTokenManager) {
        this.serviceTokenManager = serviceTokenManager;
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }
}

