/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.velocity;

import com.opensymphony.xwork.ActionContext;
import com.opensymphony.xwork.util.OgnlValueStack;
import com.zutubi.pulse.bootstrap.ComponentContext;
import com.zutubi.pulse.form.MessagesTextProvider;
import com.zutubi.pulse.form.descriptor.DescriptorFactory;
import com.zutubi.pulse.form.ui.FormSupport;
import com.zutubi.pulse.velocity.AbstractDirective;
import com.zutubi.pulse.wizard.Wizard;
import freemarker.template.Configuration;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.parser.node.Node;

public class WizardDirective
extends AbstractDirective {
    private Configuration configuration;
    private DescriptorFactory descriptorFactory;
    private String objectName;
    private String theme;

    public WizardDirective() {
        ComponentContext.autowire((Object)((Object)this));
    }

    public String getName() {
        return "wizard";
    }

    public int getType() {
        return 2;
    }

    public boolean render(InternalContextAdapter context, Writer writer, Node node) throws IOException, ResourceNotFoundException, ParseErrorException, MethodInvocationException {
        Map params = this.createPropertyMap(context, node);
        this.wireParams(params);
        OgnlValueStack stack = ActionContext.getContext().getValueStack();
        Wizard wizard = (Wizard)stack.findValue(this.objectName);
        writer.write(this.internalRender(wizard));
        return true;
    }

    public void setObject(String objectName) {
        this.objectName = objectName;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    private String internalRender(Wizard wizard) {
        Object subject = wizard.getCurrentState();
        FormSupport support = this.formSupport(subject);
        try {
            return support.renderWizard(wizard, subject);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private FormSupport formSupport(Object subject) {
        FormSupport support = new FormSupport();
        support.setConfiguration(this.configuration);
        support.setDescriptorFactory(this.descriptorFactory);
        support.setTextProvider(new MessagesTextProvider(subject));
        support.setTheme(this.theme);
        return support;
    }

    public void setFreemarkerConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setDescriptorFactory(DescriptorFactory descriptorFactory) {
        this.descriptorFactory = descriptorFactory;
    }
}

