/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;

public class UserPropsDataUpgradeTask
extends DatabaseUpgradeTask {
    public String getName() {
        return "User preference migration.";
    }

    public String getDescription() {
        return "This upgrade task migrates the user preference data out of the USER table and into the newly created USER_PROPS table.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(UpgradeContext context, Connection con) throws SQLException {
        LinkedList<UserPreferenceData> data = new LinkedList<UserPreferenceData>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareCall("select * from USER");
            rs = ps.executeQuery();
            while (rs.next()) {
                data.add(new UserPreferenceData(rs));
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close((PreparedStatement)ps);
            JDBCUtils.close(rs);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)ps);
        JDBCUtils.close((ResultSet)rs);
        try {
            ps = con.prepareStatement("insert into USER_PROPS (user_id, key, value) values (?, ?, ?)");
            for (UserPreferenceData upd : data) {
                JDBCUtils.setLong((PreparedStatement)ps, (int)1, (Long)upd.getUserId());
                if (upd.getDefaultAction() != null) {
                    JDBCUtils.setString((PreparedStatement)ps, (int)2, (String)"user.defaultAction");
                    JDBCUtils.setString((PreparedStatement)ps, (int)3, (String)upd.getDefaultAction());
                    ps.executeUpdate();
                }
                if (upd.getRefreshInterval() != null) {
                    JDBCUtils.setString((PreparedStatement)ps, (int)2, (String)"user.refreshInterval");
                    JDBCUtils.setString((PreparedStatement)ps, (int)3, (String)String.valueOf(upd.getRefreshInterval()));
                    ps.executeUpdate();
                }
                if (upd.getShowAllProjects() == null) continue;
                JDBCUtils.setString((PreparedStatement)ps, (int)2, (String)"user.showAllProjects");
                JDBCUtils.setString((PreparedStatement)ps, (int)3, (String)String.valueOf(upd.getShowAllProjects()));
                ps.executeUpdate();
            }
        }
        finally {
            JDBCUtils.close((PreparedStatement)ps);
        }
    }

    public boolean haltOnFailure() {
        return false;
    }

    private class UserPreferenceData {
        private String defaultAction = null;
        private Integer refreshInterval = null;
        private Boolean showAllProjects = null;
        private long userId;

        public UserPreferenceData(ResultSet rs) throws SQLException {
            this.userId = rs.getLong("id");
            this.defaultAction = rs.getString("defaultAction");
            this.refreshInterval = JDBCUtils.getInt((ResultSet)rs, (String)"refreshInterval");
            this.showAllProjects = JDBCUtils.getBool((ResultSet)rs, (String)"showAllProjects");
        }

        public long getUserId() {
            return this.userId;
        }

        public String getDefaultAction() {
            return this.defaultAction;
        }

        public Integer getRefreshInterval() {
            return this.refreshInterval;
        }

        public Boolean getShowAllProjects() {
            return this.showAllProjects;
        }
    }
}

