/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.bootstrap.Data;
import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.upgrade.ConfigurationAware;
import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.UpgradeException;
import com.zutubi.pulse.upgrade.UpgradeTask;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferExampleTemplatesUpgradeTask
implements UpgradeTask,
ConfigurationAware {
    private int buildNumber;
    private List<String> errors = new LinkedList<String>();
    private MasterConfigurationManager configurationManager;

    @Override
    public String getName() {
        return "Transfer example templates";
    }

    @Override
    public String getDescription() {
        return "Transfer example templates into the PULSE_DATA/config/templates directory.";
    }

    public void setBuildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
    }

    @Override
    public int getBuildNumber() {
        return this.buildNumber;
    }

    @Override
    public void execute(UpgradeContext context) throws UpgradeException {
        Data data = this.configurationManager.getData();
        data.transferExampleTemplates(this.configurationManager.getSystemPaths());
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public boolean haltOnFailure() {
        return false;
    }

    @Override
    public boolean hasFailed() {
        return this.errors.size() > 0;
    }

    @Override
    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

