/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.config.ConfigSupport;
import com.zutubi.pulse.upgrade.ConfigurationAware;
import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.UpgradeException;
import com.zutubi.pulse.upgrade.UpgradeTask;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameHostNamePropertyUpgradeTask
implements UpgradeTask,
ConfigurationAware {
    protected int buildNumber;
    private List<String> errors = new LinkedList<String>();
    private MasterConfigurationManager configurationManager;

    @Override
    public String getName() {
        return "Rename hostname property";
    }

    @Override
    public String getDescription() {
        return "Rename and upgrade the hostname property to the new base url property";
    }

    @Override
    public int getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
    }

    @Override
    public void execute(UpgradeContext context) throws UpgradeException {
        ConfigSupport appConfig = (ConfigSupport)this.configurationManager.getAppConfig();
        if (appConfig.hasProperty("host.name")) {
            String hostname = appConfig.getProperty("host.name");
            appConfig.removeProperty("host.name");
            String baseUrl = "http://" + hostname;
            if (baseUrl.endsWith("/")) {
                baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
            }
            appConfig.setProperty("webapp.base.url", baseUrl);
        }
    }

    @Override
    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public boolean haltOnFailure() {
        return false;
    }

    @Override
    public boolean hasFailed() {
        return false;
    }
}

