/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class RelativePathUpgradeTask
extends DatabaseUpgradeTask {
    public String getName() {
        return "Relative paths";
    }

    public String getDescription() {
        return "Upgrade to change absolute paths into paths relative to data root";
    }

    public void execute(UpgradeContext context, Connection con) throws SQLException {
        this.updateTable(con, "build_result", context.getData().getData().getAbsolutePath());
        this.updateTable(con, "recipe_result", context.getData().getData().getAbsolutePath());
        this.updateTable(con, "command_result", context.getData().getData().getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTable(Connection con, String table, String dataPath) throws SQLException {
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareCall("SELECT id, outputdir FROM " + table);
            rs = stmt.executeQuery();
            while (rs.next()) {
                this.relativisePath(con, table, JDBCUtils.getLong((ResultSet)rs, (String)"id"), JDBCUtils.getString((ResultSet)rs, (String)"outputdir"), dataPath);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(stmt);
            JDBCUtils.close(rs);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)stmt);
        JDBCUtils.close((ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void relativisePath(Connection con, String table, Long id, String path, String dataPath) throws SQLException {
        if (path != null && path.startsWith(dataPath)) {
            if ((path = path.substring(dataPath.length())).startsWith(File.separator) || path.startsWith("/")) {
                path = path.substring(1);
            }
            CallableStatement stmt = null;
            try {
                stmt = con.prepareCall("UPDATE " + table + " SET outputdir = ? WHERE id = ?");
                stmt.setString(1, path);
                stmt.setLong(2, (long)id);
                stmt.executeUpdate();
            }
            catch (Throwable throwable) {
                JDBCUtils.close(stmt);
                throw throwable;
            }
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    public boolean haltOnFailure() {
        return true;
    }
}

