/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.AbstractSchemaRefactorUpgradeTask;
import com.zutubi.pulse.upgrade.tasks.SchemaRefactor;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PostBuildActionSpecificationsUpgradeTask
extends AbstractSchemaRefactorUpgradeTask {
    private PreparedStatement insertStatement = null;

    public String getName() {
        return "Post build action specifications";
    }

    public String getDescription() {
        return "Upgrades post build action storage of related build specifications (CIB-927)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRefactor(UpgradeContext context, Connection con, SchemaRefactor refactor) throws SQLException {
        try {
            this.insertStatement = con.prepareStatement("INSERT INTO POST_BUILD_ACTION_SPECIFICATIONS (SPECIFICATION_ID, ACTION_ID) VALUES (?, ?)");
            this.addActions(con);
            refactor.dropColumn("BUILD_SPECIFICATION", "ACTION_ID");
        }
        finally {
            JDBCUtils.close((PreparedStatement)this.insertStatement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addActions(Connection con) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT ID, ACTION_ID FROM BUILD_SPECIFICATION");
            rs = stmt.executeQuery();
            while (rs.next()) {
                Long id = JDBCUtils.getLong((ResultSet)rs, (String)"ID");
                Long action = JDBCUtils.getLong((ResultSet)rs, (String)"ACTION_ID");
                if (action == null) continue;
                this.addAction(id, action);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
    }

    private void addAction(Long spec, Long action) throws SQLException {
        this.insertStatement.setLong(1, spec);
        this.insertStatement.setLong(2, action);
        this.insertStatement.executeUpdate();
    }

    public boolean haltOnFailure() {
        return true;
    }
}

