/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class OrphanedTriggerUpgradeTask
extends DatabaseUpgradeTask {
    public String getName() {
        return "Orphaned triggers";
    }

    public String getDescription() {
        return "Deletes any orphaned triggers";
    }

    public boolean haltOnFailure() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(UpgradeContext context, Connection con) throws SQLException {
        List<Long> projects = this.getAllProjects(con);
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareCall("SELECT id, project FROM trigger");
            rs = stmt.executeQuery();
            while (rs.next()) {
                Long project = JDBCUtils.getLong((ResultSet)rs, (String)"project");
                if (project == 0L || projects.contains(project)) continue;
                this.deleteTrigger(con, JDBCUtils.getLong((ResultSet)rs, (String)"id"));
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close((PreparedStatement)stmt);
            JDBCUtils.close(rs);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)stmt);
        JDBCUtils.close((ResultSet)rs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTrigger(Connection con, Long id) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("DELETE FROM trigger where id = ?");
            stmt.setLong(1, (long)id);
            stmt.execute();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }
}

