/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.core.model.TestCaseResult;
import com.zutubi.pulse.core.model.TestSuitePersister;
import com.zutubi.pulse.core.model.TestSuiteResult;
import com.zutubi.pulse.util.FileSystemUtils;
import com.zutubi.pulse.util.IOUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import nu.xom.Text;

public class OriginalTestSuitePersister {
    private static final Logger LOG = Logger.getLogger(TestSuitePersister.class);
    private static final String SUITE_FILE_NAME = "suite.xml";
    private static final String ELEMENT_SUITE = "suite";
    private static final String ELEMENT_CASE = "case";
    private static final String ELEMENT_MESSAGE = "message";
    private static final String ATTRIBUTE_TOTAL = "total";
    private static final String ATTRIBUTE_FAILURES = "failures";
    private static final String ATTRIBUTE_ERRORS = "errors";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_DURATION = "duration";
    private static final String ATTRIBUTE_STATUS = "status";

    public void write(TestSuiteResult suite, File directory) throws IOException {
        for (TestSuiteResult childSuite : suite.getSuites()) {
            File suiteDir = new File(directory, this.encodeName(childSuite.getName()));
            FileSystemUtils.createDirectory((File)suiteDir);
            this.write(childSuite, suiteDir);
        }
        this.writeCases(suite, new File(directory, SUITE_FILE_NAME));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCases(TestSuiteResult suite, File file) throws IOException {
        Document doc = this.suiteToDoc(suite);
        BufferedOutputStream bos = null;
        try {
            FileOutputStream fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            Serializer serializer = new Serializer((OutputStream)bos);
            serializer.write(doc);
        }
        catch (Throwable throwable) {
            IOUtils.close(bos);
            throw throwable;
        }
        IOUtils.close((Closeable)bos);
    }

    private Document suiteToDoc(TestSuiteResult suite) {
        Element root = new Element(ELEMENT_SUITE);
        root.addAttribute(new Attribute(ATTRIBUTE_DURATION, Long.toString(suite.getDuration())));
        for (TestSuiteResult child : suite.getSuites()) {
            Element suiteElement = new Element(ELEMENT_SUITE);
            suiteElement.addAttribute(new Attribute(ATTRIBUTE_NAME, child.getName()));
            suiteElement.addAttribute(new Attribute(ATTRIBUTE_TOTAL, Integer.toString(child.getTotal())));
            suiteElement.addAttribute(new Attribute(ATTRIBUTE_FAILURES, Integer.toString(child.getFailures())));
            suiteElement.addAttribute(new Attribute(ATTRIBUTE_ERRORS, Integer.toString(child.getErrors())));
            suiteElement.addAttribute(new Attribute(ATTRIBUTE_DURATION, Long.toString(child.getDuration())));
            root.appendChild((Node)suiteElement);
        }
        for (TestSuiteResult child : suite.getCases()) {
            Element caseElement = new Element(ELEMENT_CASE);
            caseElement.addAttribute(new Attribute(ATTRIBUTE_NAME, child.getName()));
            caseElement.addAttribute(new Attribute(ATTRIBUTE_DURATION, Long.toString(child.getDuration())));
            caseElement.addAttribute(new Attribute(ATTRIBUTE_STATUS, child.getStatusName()));
            String message = child.getMessage();
            if (message != null) {
                Element messageElement = new Element(ELEMENT_MESSAGE);
                messageElement.appendChild(message);
                caseElement.appendChild((Node)messageElement);
            }
            root.appendChild((Node)caseElement);
        }
        return new Document(root);
    }

    public TestSuiteResult read(String name, File directory, boolean deep, boolean failuresOnly, int limit) throws IOException, ParsingException {
        return this.read(name, directory, deep, failuresOnly, new Counter(limit));
    }

    public TestSuiteResult read(String name, File directory, boolean deep, boolean failuresOnly, Counter counter) throws IOException, ParsingException {
        File suiteFile = new File(directory, SUITE_FILE_NAME);
        Document doc = this.readDoc(suiteFile);
        long duration = this.getDuration(doc.getRootElement());
        TestSuiteResult suite = new TestSuiteResult(name, duration);
        this.loadSuites(suite, doc, directory, deep, failuresOnly, counter);
        this.loadCases(suite, doc, failuresOnly, counter);
        return suite;
    }

    private void loadSuites(TestSuiteResult suite, Document doc, File directory, boolean deep, boolean failuresOnly, Counter counter) throws IOException, ParsingException {
        Elements elements = doc.getRootElement().getChildElements(ELEMENT_SUITE);
        for (int i = 0; i < elements.size(); ++i) {
            Element element = elements.get(i);
            String name = element.getAttributeValue(ATTRIBUTE_NAME);
            long duration = this.getDuration(element);
            int total = this.getIntAttribute(element, ATTRIBUTE_TOTAL);
            int errors = this.getIntAttribute(element, ATTRIBUTE_ERRORS);
            int failures = this.getIntAttribute(element, ATTRIBUTE_FAILURES);
            if (name == null || failuresOnly && errors == 0 && failures == 0) continue;
            if (deep) {
                File child = new File(directory, this.encodeName(name));
                if (!child.isDirectory()) continue;
                suite.add(this.read(name, child, deep, failuresOnly, counter));
                if (!counter.isExhausted()) continue;
                return;
            }
            suite.add(new TestSuiteResult(name, duration, total, errors, failures));
        }
    }

    private int getIntAttribute(Element element, String attribute) {
        int result = 0;
        String val = element.getAttributeValue(attribute);
        if (val != null) {
            try {
                result = Integer.parseInt(val);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    private void loadCases(TestSuiteResult suite, Document doc, boolean failuresOnly, Counter counter) {
        Elements elements = doc.getRootElement().getChildElements(ELEMENT_CASE);
        for (int i = 0; i < elements.size(); ++i) {
            Element element = elements.get(i);
            TestCaseResult.Status status = this.getStatus(element);
            if (failuresOnly && status == TestCaseResult.Status.PASS) continue;
            suite.add(new TestCaseResult(element.getAttributeValue(ATTRIBUTE_NAME), this.getDuration(element), status, this.getMessage(element)));
            counter.add();
            if (!counter.isExhausted()) continue;
            return;
        }
    }

    private long getDuration(Element element) {
        long result = -1L;
        String attributeValue = element.getAttributeValue(ATTRIBUTE_DURATION);
        if (attributeValue != null) {
            try {
                result = Long.parseLong(attributeValue);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return result;
    }

    private TestCaseResult.Status getStatus(Element element) {
        TestCaseResult.Status status = TestCaseResult.Status.PASS;
        String statusName = element.getAttributeValue(ATTRIBUTE_STATUS);
        if (statusName != null) {
            try {
                status = TestCaseResult.Status.valueOf((String)statusName);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        return status;
    }

    private String getMessage(Element element) {
        Node child;
        Elements messageElements = element.getChildElements(ELEMENT_MESSAGE);
        if (messageElements.size() > 0 && messageElements.get(0).getChildCount() > 0 && (child = messageElements.get(0).getChild(0)) instanceof Text) {
            return child.getValue();
        }
        return null;
    }

    private Document readDoc(File file) throws IOException, ParsingException {
        Builder builder = new Builder();
        return builder.build(file);
    }

    private String encodeName(String name) {
        try {
            return URLEncoder.encode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return name;
        }
    }

    private String decodeName(String name) {
        try {
            return URLDecoder.decode(name, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return name;
        }
    }

    private class Counter {
        public int limit;
        public int count;

        public Counter(int limit) {
            this.limit = limit;
            this.count = 0;
        }

        public void add() {
            ++this.count;
        }

        public boolean isExhausted() {
            return this.limit > 0 && this.count >= this.limit;
        }
    }
}

