/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.bootstrap.DatabaseConfig;
import com.zutubi.pulse.upgrade.DataSourceAware;
import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.UpgradeException;
import com.zutubi.pulse.upgrade.UpgradeTask;
import com.zutubi.pulse.upgrade.tasks.HackyConnectionProvider;
import com.zutubi.pulse.upgrade.tasks.MutableConfiguration;
import com.zutubi.pulse.upgrade.tasks.SchemaRefactor;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MigrateSchemaUpgradeTask
implements DataSourceAware,
UpgradeTask {
    private List<String> mappings = new LinkedList<String>();
    private List<String> errors = new LinkedList<String>();
    protected DataSource dataSource;
    private int buildNumber;
    private DatabaseConfig databaseConfig;

    @Override
    public int getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
    }

    @Override
    public String getDescription() {
        return "The schema upgrade associated with build " + this.buildNumber;
    }

    @Override
    public String getName() {
        return "Schema upgrade (" + this.getBuildNumber() + ")";
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public boolean hasFailed() {
        return this.getErrors().size() > 0;
    }

    @Override
    public boolean haltOnFailure() {
        return true;
    }

    @Override
    public void execute(UpgradeContext context) throws UpgradeException {
        try {
            MutableConfiguration config = new MutableConfiguration();
            Properties props = this.databaseConfig.getHibernateProperties();
            props.put("hibernate.connection.provider_class", "com.zutubi.pulse.upgrade.tasks.HackyConnectionProvider");
            HackyConnectionProvider.dataSource = this.dataSource;
            for (String mapping : this.mappings) {
                ClassPathResource resource = new ClassPathResource(mapping);
                config.addInputStream(resource.getInputStream());
            }
            SchemaRefactor refactor = new SchemaRefactor(config, props);
            refactor.sync();
            List<Exception> exceptions = refactor.getExceptions();
            for (Exception e : exceptions) {
                this.getErrors().add(e.getClass().getName() + ": Cause: " + e.getMessage());
            }
        }
        catch (IOException e) {
            throw new UpgradeException(e);
        }
    }

    public void setMapping(String mapping) {
        this.mappings.clear();
        this.mappings.add(mapping);
    }

    public void setMappings(List<String> mappings) {
        this.mappings = mappings;
    }

    @Override
    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setDatabaseConfig(DatabaseConfig config) {
        this.databaseConfig = config;
    }
}

