/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.upgrade.tasks.HibernateUtils;
import com.zutubi.pulse.util.JDBCUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;

public class MavenCapturesUpgradeTask
extends DatabaseUpgradeTask {
    private static final Logger LOG = Logger.getLogger(MavenCapturesUpgradeTask.class);

    public String getName() {
        return "Maven test report capturing";
    }

    public String getDescription() {
        return "This upgrade task adds artifacts to capture test reports for existing maven (and maven 2) projects";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(UpgradeContext context, Connection con) throws SQLException {
        LinkedList<PulseFileDetailsData> data = new LinkedList<PulseFileDetailsData>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareCall("select * from BOB_FILE_DETAILS where SOURCE_TYPE like 'MAVEN%'");
            rs = ps.executeQuery();
            while (rs.next()) {
                data.add(new PulseFileDetailsData(rs));
            }
        }
        catch (Exception e) {
            try {
                LOG.warning((Throwable)e);
            }
            catch (Throwable throwable) {
                JDBCUtils.close((PreparedStatement)ps);
                JDBCUtils.close(rs);
                throw throwable;
            }
            JDBCUtils.close((PreparedStatement)ps);
            JDBCUtils.close((ResultSet)rs);
        }
        JDBCUtils.close((PreparedStatement)ps);
        JDBCUtils.close((ResultSet)rs);
        long nextId = HibernateUtils.getNextId(con);
        PreparedStatement processorsPs = null;
        try {
            ps = con.prepareStatement("insert into CAPTURE (id, name, includes, details_id, type) values (?, ?, ?, ?, 'DIRECTORY')");
            processorsPs = con.prepareStatement("insert into CAPTURE_PROCESSORS (capture_id, processor) values (?, ?)");
            for (PulseFileDetailsData upd : data) {
                JDBCUtils.setLong((PreparedStatement)ps, (int)1, (Long)(++nextId));
                JDBCUtils.setString((PreparedStatement)ps, (int)2, (String)"test reports");
                if (upd.isMaven()) {
                    JDBCUtils.setString((PreparedStatement)ps, (int)3, (String)"**/target/test-reports/TEST-*.xml");
                } else {
                    JDBCUtils.setString((PreparedStatement)ps, (int)3, (String)"**/target/surefire-reports/TEST-*.xml");
                }
                JDBCUtils.setLong((PreparedStatement)ps, (int)4, (Long)upd.getId());
                ps.executeUpdate();
                JDBCUtils.setLong((PreparedStatement)processorsPs, (int)1, (Long)nextId);
                JDBCUtils.setString((PreparedStatement)processorsPs, (int)2, (String)"junit");
                processorsPs.executeUpdate();
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close((PreparedStatement)ps);
            JDBCUtils.close(processorsPs);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)ps);
        JDBCUtils.close((PreparedStatement)processorsPs);
    }

    public boolean haltOnFailure() {
        return false;
    }

    private class PulseFileDetailsData {
        private long projectId;
        private boolean isMaven;

        public PulseFileDetailsData(ResultSet rs) throws SQLException {
            this.projectId = rs.getLong("id");
            this.isMaven = rs.getString("source_type").equalsIgnoreCase("maven");
        }

        public long getId() {
            return this.projectId;
        }

        public boolean isMaven() {
            return this.isMaven;
        }
    }
}

