/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.model.BuildSpecification;
import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncrementalBuildUpgradeTask
extends DatabaseUpgradeTask {
    @Override
    public String getName() {
        return "Incremental builds";
    }

    @Override
    public String getDescription() {
        return "Upgrade to support new checkout schemes for incremental building";
    }

    @Override
    public void execute(UpgradeContext context, Connection con) throws SQLException {
        this.updateSpecs(con);
        this.dropColumn(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSpecs(Connection con) throws SQLException {
        Map<Long, String> schemes = this.lookupSchemes(con);
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareCall("SELECT id, project_id FROM build_specification");
            rs = stmt.executeQuery();
            while (rs.next()) {
                this.setCheckoutScheme(con, JDBCUtils.getLong((ResultSet)rs, (String)"id"), schemes.get(JDBCUtils.getLong((ResultSet)rs, (String)"project_id")));
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Long, String> lookupSchemes(Connection con) throws SQLException {
        CallableStatement stmt = null;
        ResultSet rs = null;
        TreeMap<Long, String> schemes = new TreeMap<Long, String>();
        try {
            stmt = con.prepareCall("SELECT id, checkout_scheme FROM project");
            rs = stmt.executeQuery();
            while (rs.next()) {
                schemes.put(JDBCUtils.getLong((ResultSet)rs, (String)"id"), JDBCUtils.getString((ResultSet)rs, (String)"checkout_scheme"));
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
        return schemes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCheckoutScheme(Connection con, Long id, String scheme) throws SQLException {
        BuildSpecification.CheckoutScheme newScheme = this.convertScheme(scheme);
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("UPDATE build_specification SET checkout_scheme = ?, force_clean = false WHERE id = ?");
            stmt.setString(1, newScheme.toString());
            stmt.setLong(2, (long)id);
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    private BuildSpecification.CheckoutScheme convertScheme(String scheme) {
        if (scheme == null) {
            return BuildSpecification.CheckoutScheme.CLEAN_CHECKOUT;
        }
        if (scheme.equals("CHECKOUT_AND_UPDATE")) {
            return BuildSpecification.CheckoutScheme.CLEAN_UPDATE;
        }
        return BuildSpecification.CheckoutScheme.CLEAN_CHECKOUT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropColumn(Connection con) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("ALTER TABLE project DROP COLUMN checkout_scheme");
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    @Override
    public boolean haltOnFailure() {
        return true;
    }
}

