/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.util.JDBCUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class HibernateUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getNextId(Connection con) throws SQLException {
        long nextHi;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement("select NEXT_HI from HIBERNATE_UNIQUE_KEY");
            rs = ps.executeQuery();
            rs.next();
            nextHi = rs.getLong(1);
        }
        catch (Throwable throwable) {
            JDBCUtils.close((PreparedStatement)ps);
            JDBCUtils.close(rs);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)ps);
        JDBCUtils.close((ResultSet)rs);
        try {
            ps = con.prepareStatement("UPDATE hibernate_unique_key SET next_hi = ? where next_hi = ?");
            JDBCUtils.setLong((PreparedStatement)ps, (int)1, (Long)(++nextHi));
            JDBCUtils.setLong((PreparedStatement)ps, (int)2, (Long)(nextHi - 1L));
            ps.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)ps);
        }
        return HibernateUtils.getNextId(nextHi);
    }

    private static long getNextId(long nextHi) {
        return nextHi * 32768L + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureNextId(Connection con, long lastId) throws SQLException {
        long nextHi;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement("select NEXT_HI from HIBERNATE_UNIQUE_KEY");
            rs = ps.executeQuery();
            rs.next();
            nextHi = rs.getLong(1);
        }
        catch (Throwable throwable) {
            JDBCUtils.close((PreparedStatement)ps);
            JDBCUtils.close(rs);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)ps);
        JDBCUtils.close((ResultSet)rs);
        boolean updateRequired = false;
        while (lastId >= HibernateUtils.getNextId(nextHi)) {
            updateRequired = true;
            ++nextHi;
        }
        if (updateRequired) {
            try {
                ps = con.prepareStatement("UPDATE hibernate_unique_key SET next_hi = ?");
                JDBCUtils.setLong((PreparedStatement)ps, (int)1, (Long)nextHi);
                ps.executeUpdate();
            }
            finally {
                JDBCUtils.close((PreparedStatement)ps);
            }
        }
    }
}

