/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.DataSourceAware;
import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.UpgradeException;
import com.zutubi.pulse.upgrade.UpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.acegisecurity.providers.encoding.Md5PasswordEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlexibleConditionUpgradeTask
implements UpgradeTask,
DataSourceAware {
    private DataSource dataSource;
    private int buildNumber;
    private List<String> errors = new LinkedList<String>();

    @Override
    public String getName() {
        return "Update subscription conditions";
    }

    @Override
    public String getDescription() {
        return "This upgrade task updates the format of the conditions stored with notification subscriptions";
    }

    @Override
    public int getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(UpgradeContext context) throws UpgradeException {
        Connection con = null;
        try {
            con = this.dataSource.getConnection();
            LinkedList<IdCondition> results = new LinkedList<IdCondition>();
            CallableStatement stmt = null;
            ResultSet rs = null;
            try {
                stmt = con.prepareCall("SELECT id, condition FROM subscription");
                rs = stmt.executeQuery();
                while (rs.next()) {
                    results.add(new IdCondition(JDBCUtils.getLong((ResultSet)rs, (String)"id"), JDBCUtils.getString((ResultSet)rs, (String)"condition")));
                }
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs);
                JDBCUtils.close((PreparedStatement)stmt);
                throw throwable;
            }
            JDBCUtils.close((ResultSet)rs);
            JDBCUtils.close((PreparedStatement)stmt);
            Md5PasswordEncoder encoder = new Md5PasswordEncoder();
            for (IdCondition data : results) {
                data.condition = this.mapCondition(data.condition);
            }
            PreparedStatement ps = null;
            try {
                ps = con.prepareStatement("UPDATE subscription SET condition = ? WHERE id = ?");
                for (IdCondition data : results) {
                    JDBCUtils.setString((PreparedStatement)ps, (int)1, (String)data.condition);
                    JDBCUtils.setLong((PreparedStatement)ps, (int)2, (Long)data.id);
                    int rowCount = ps.executeUpdate();
                    if (rowCount == 1) continue;
                    this.errors.add("Failed to update condition. Row count is " + rowCount + " where 1 was expected.");
                }
            }
            finally {
                JDBCUtils.close((PreparedStatement)ps);
            }
        }
        catch (SQLException e) {
            this.errors.add("SQLException: " + e.getMessage());
        }
        finally {
            JDBCUtils.close((Connection)con);
        }
    }

    private String mapCondition(String condition) {
        String ALL_BUILDS = "all builds";
        String ALL_CHANGED = "all changed";
        String ALL_FAILED = "all failed";
        String ALL_CHANGED_OR_FAILED = "all changed or failed";
        String ALL_FAILED_AND_FIRST_SUCCESS = "all failed and first success";
        if (condition.equals("all builds")) {
            return "true";
        }
        if (condition.equals("all changed")) {
            return "changed";
        }
        if (condition.equals("all failed")) {
            return "not success";
        }
        if (condition.equals("all changed or failed")) {
            return "changed or not success";
        }
        if (condition.equals("all failed and first success")) {
            return "not success or state.change";
        }
        return "false";
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public boolean hasFailed() {
        return this.getErrors().size() > 0;
    }

    @Override
    public boolean haltOnFailure() {
        return false;
    }

    @Override
    public void setDataSource(DataSource source) {
        this.dataSource = source;
    }

    private class IdCondition {
        protected long id;
        protected String condition;

        IdCondition(long id, String condition) {
            this.id = id;
            this.condition = condition;
        }
    }
}

