/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class EstimatedRunningTimeUpgradeTask
extends DatabaseUpgradeTask {
    public String getName() {
        return "Estimated running time";
    }

    public String getDescription() {
        return "Upgrade to result time stamps to support estimated running time";
    }

    public void execute(UpgradeContext context, Connection con) throws SQLException {
        this.addColumn("build_result", con);
        this.addColumn("recipe_result", con);
        this.addColumn("command_result", con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addColumn(String table, Connection con) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("ALTER TABLE " + table + " ADD COLUMN estimated_running_time BIGINT DEFAULT -1");
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            JDBCUtils.close(stmt);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)stmt);
    }

    public boolean haltOnFailure() {
        return true;
    }
}

