/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class DefaultSpecificationUpgradeTask
extends DatabaseUpgradeTask {
    public String getName() {
        return "Default specification";
    }

    public String getDescription() {
        return "Marks one build specification as the default for each project";
    }

    public void execute(UpgradeContext context, Connection con) throws SQLException {
        List<Long> projects = this.getAllProjects(con);
        for (Long id : projects) {
            this.updateProject(con, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProject(Connection con, Long id) throws SQLException {
        CallableStatement stmt = null;
        ResultSet rs = null;
        Long defaultId = null;
        try {
            stmt = con.prepareCall("SELECT id, name FROM build_specification WHERE project_id = ?");
            stmt.setLong(1, (long)id);
            rs = stmt.executeQuery();
            while (rs.next()) {
                if (defaultId == null) {
                    defaultId = rs.getLong("id");
                    continue;
                }
                if (!rs.getString("name").equals("default")) continue;
                defaultId = rs.getLong("id");
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
        if (defaultId != null) {
            this.setDefault(con, id, defaultId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDefault(Connection con, Long id, Long defaultId) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("UPDATE project SET default_specification = ? WHERE id = ?");
            stmt.setLong(1, (long)defaultId);
            stmt.setLong(2, (long)id);
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    public boolean haltOnFailure() {
        return true;
    }
}

