/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DashboardProjectsUpgradeTask
extends DatabaseUpgradeTask {
    @Override
    public String getName() {
        return "Dashboard projects";
    }

    @Override
    public String getDescription() {
        return "Upgrade to convert to a new scheme for dashboard project preferences";
    }

    @Override
    public void execute(UpgradeContext context, Connection con) throws SQLException {
        this.updateProperties(con);
        this.dropColumns(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProperties(Connection con) throws SQLException {
        CallableStatement stmt = null;
        ResultSet rs = null;
        TreeMap<Long, List<Long>> userProjects = new TreeMap<Long, List<Long>>();
        try {
            stmt = con.prepareCall("SELECT id, user_id FROM project where user_id is not null");
            rs = stmt.executeQuery();
            while (rs.next()) {
                long project = rs.getLong("id");
                long user = rs.getLong("user_id");
                LinkedList<Long> projects = (LinkedList<Long>)userProjects.get(user);
                if (projects == null) {
                    projects = new LinkedList<Long>();
                    userProjects.put(user, projects);
                }
                projects.add(project);
            }
            if (userProjects.size() > 0) {
                this.invertUserProjects(con, userProjects);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
    }

    private void invertUserProjects(Connection con, Map<Long, List<Long>> userProjects) throws SQLException {
        List<Long> allProjects = this.getAllProjects(con);
        for (Map.Entry<Long, List<Long>> entry : userProjects.entrySet()) {
            LinkedList<Long> hidden = new LinkedList<Long>(allProjects);
            hidden.removeAll((Collection)entry.getValue());
            this.addHiddenProjects(con, entry.getKey(), hidden);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHiddenProjects(Connection con, Long user, List<Long> hidden) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("INSERT INTO user_hidden_projects VALUES (?, ?)");
            for (Long project : hidden) {
                stmt.setLong(1, (long)user);
                stmt.setLong(2, (long)project);
                stmt.executeUpdate();
            }
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropColumns(Connection con) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("ALTER TABLE user DROP COLUMN showallprojects");
            stmt.executeUpdate();
            JDBCUtils.close((PreparedStatement)stmt);
            stmt = con.prepareCall("UPDATE project SET user_id = null");
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    @Override
    public boolean haltOnFailure() {
        return true;
    }
}

