/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class CustomNotificationTemplatesUpgradeTask
extends DatabaseUpgradeTask {
    public String getName() {
        return "Custom notification templates";
    }

    public String getDescription() {
        return "Upgrades subscriptions to allow a choice of notification templates";
    }

    public void execute(UpgradeContext context, Connection con) throws SQLException, IOException {
        this.updateSubscriptions(con);
        this.dropColumn(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSubscriptions(Connection con) throws SQLException, IOException {
        CallableStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareCall("SELECT id, personal, contact_id FROM subscription");
            rs = stmt.executeQuery();
            while (rs.next()) {
                Long id = JDBCUtils.getLong((ResultSet)rs, (String)"id");
                Boolean personal = JDBCUtils.getBool((ResultSet)rs, (String)"personal");
                Long contactId = JDBCUtils.getLong((ResultSet)rs, (String)"contact_id");
                String template = this.getTemplate(con, contactId);
                this.updateSubscription(con, id, personal, template);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)stmt);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getTemplate(Connection con, Long contactId) throws SQLException, IOException {
        ResultSet rs;
        CallableStatement stmt;
        String result;
        block4: {
            result = "html-email";
            stmt = null;
            rs = null;
            try {
                stmt = con.prepareCall("SELECT type, properties FROM contact_point WHERE id = ?");
                stmt.setLong(1, (long)contactId);
                rs = stmt.executeQuery();
                if (!rs.next()) break block4;
                String type = JDBCUtils.getString((ResultSet)rs, (String)"type");
                if (type.equals("EMAIL")) {
                    Properties properties = new Properties();
                    properties.load(new ByteArrayInputStream(rs.getBytes("properties")));
                    String emailType = properties.getProperty("type");
                    if (emailType != null) {
                        result = emailType.equals("html") ? "html-email" : "plain-text-email";
                    }
                    this.updateProperties(con, contactId, properties);
                    break block4;
                }
                result = "simple-instant-message";
            }
            catch (Throwable throwable) {
                JDBCUtils.close(rs);
                JDBCUtils.close((PreparedStatement)stmt);
                throw throwable;
            }
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)stmt);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSubscription(Connection con, Long id, Boolean personal, String template) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("UPDATE subscription SET type = ?, template = ? WHERE id = ?");
            stmt.setString(1, personal != false ? "PERSONAL" : "PROJECT");
            stmt.setString(2, template);
            stmt.setLong(3, (long)id);
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProperties(Connection con, Long contactId, Properties properties) throws IOException, SQLException {
        properties.remove("type");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        properties.store(baos, "");
        byte[] data = baos.toByteArray();
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("UPDATE contact_point SET properties = ? WHERE id = ?");
            stmt.setBytes(1, data);
            stmt.setLong(2, (long)contactId);
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropColumn(Connection con) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall("ALTER TABLE subscription DROP COLUMN personal");
            stmt.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)stmt);
        }
    }

    public boolean haltOnFailure() {
        return true;
    }
}

