/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.upgrade.tasks.HibernateUtils;
import com.zutubi.pulse.util.JDBCUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;

public class CopySharedBuildReasonDataPatchUpgradeTask
extends DatabaseUpgradeTask {
    private static final Logger LOG = Logger.getLogger(CopySharedBuildReasonDataPatchUpgradeTask.class);

    public String getName() {
        return "Copy shared build reason data patch.";
    }

    public String getDescription() {
        return "This upgrade tasks fixes data problems resulting from build reasons being shared by multiple build results. See CIB-723 for details.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(UpgradeContext context, Connection con) throws SQLException {
        LinkedList<Long> reasons = new LinkedList<Long>();
        PreparedStatement select = null;
        ResultSet rs = null;
        try {
            String selectClonedScms = "SELECT reason FROM build_result GROUP BY reason HAVING count(reason) > 1";
            select = con.prepareStatement(selectClonedScms);
            rs = select.executeQuery();
            while (rs.next()) {
                reasons.add(JDBCUtils.getLong((ResultSet)rs, (String)"reason"));
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(select);
            JDBCUtils.close(rs);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)select);
        JDBCUtils.close((ResultSet)rs);
        LinkedList<Reason> reasonData = new LinkedList<Reason>();
        try {
            String selectScm = "SELECT * FROM build_reason WHERE id = ?";
            select = con.prepareStatement(selectScm);
            Iterator i$ = reasons.iterator();
            while (i$.hasNext()) {
                long scmId = (Long)i$.next();
                JDBCUtils.setLong((PreparedStatement)select, (int)1, (Long)scmId);
                rs = select.executeQuery();
                if (rs.next()) {
                    reasonData.add(new Reason(rs));
                }
                JDBCUtils.close((ResultSet)rs);
            }
        }
        finally {
            JDBCUtils.close((PreparedStatement)select);
            JDBCUtils.close((ResultSet)rs);
        }
        PreparedStatement clone = null;
        PreparedStatement update = null;
        try {
            String selectBuildResults = "SELECT id FROM build_result WHERE reason = ?";
            select = con.prepareStatement(selectBuildResults);
            String cloneBuildReason = "INSERT INTO build_reason (id, reason_type, details, user) VALUES (?, ?, ?, ?)";
            clone = con.prepareStatement(cloneBuildReason);
            String updateBuildResult = "UPDATE build_result SET reason = ? WHERE id = ?";
            update = con.prepareStatement(updateBuildResult);
            long nextId = HibernateUtils.getNextId(con);
            for (Reason reason : reasonData) {
                try {
                    JDBCUtils.setLong((PreparedStatement)select, (int)1, (Long)reason.id);
                    rs = select.executeQuery();
                    rs.next();
                    while (rs.next()) {
                        long resultId = JDBCUtils.getLong((ResultSet)rs, (String)"id");
                        JDBCUtils.setLong((PreparedStatement)clone, (int)1, (Long)nextId);
                        JDBCUtils.setString((PreparedStatement)clone, (int)2, (String)reason.reasonType);
                        JDBCUtils.setString((PreparedStatement)clone, (int)3, (String)reason.details);
                        JDBCUtils.setString((PreparedStatement)clone, (int)4, (String)reason.user);
                        if (clone.executeUpdate() != 1) {
                            LOG.error("Failed to insert new build reason.");
                        }
                        JDBCUtils.setLong((PreparedStatement)update, (int)1, (Long)nextId);
                        JDBCUtils.setLong((PreparedStatement)update, (int)2, (Long)resultId);
                        if (update.executeUpdate() != 1) {
                            LOG.error("Failed to update build result " + resultId + " to reference new build reason " + nextId + ".");
                        }
                        nextId = HibernateUtils.getNextId(con);
                    }
                }
                finally {
                    JDBCUtils.close((ResultSet)rs);
                }
            }
            HibernateUtils.ensureNextId(con, nextId);
        }
        catch (Throwable throwable) {
            JDBCUtils.close((PreparedStatement)select);
            JDBCUtils.close(clone);
            JDBCUtils.close(update);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)select);
        JDBCUtils.close((PreparedStatement)clone);
        JDBCUtils.close((PreparedStatement)update);
    }

    public boolean haltOnFailure() {
        return false;
    }

    private class Reason {
        public long id;
        public String reasonType;
        public String details;
        public String user;

        public Reason(ResultSet rs) throws SQLException {
            this.id = JDBCUtils.getLong((ResultSet)rs, (String)"id");
            this.reasonType = JDBCUtils.getString((ResultSet)rs, (String)"reason_type");
            this.details = JDBCUtils.getString((ResultSet)rs, (String)"details");
            this.user = JDBCUtils.getString((ResultSet)rs, (String)"user");
        }
    }
}

