/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.util.JDBCUtils;
import com.zutubi.pulse.util.PropertiesType;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class CommitMessageLinkMigrationUpgradeTask
extends DatabaseUpgradeTask {
    public void execute(UpgradeContext context, Connection con) throws IOException, SQLException {
        this.updateTypeField(con);
        this.createProperties(con);
        this.dropColumn(con, "commit_message_transformer", "expression");
        this.dropColumn(con, "commit_message_transformer", "replacement");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createProperties(Connection con) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement("SELECT * FROM commit_message_transformer");
            rs = ps.executeQuery();
            PreparedStatement update = null;
            try {
                update = con.prepareStatement("UPDATE commit_message_transformer SET properties = ? WHERE id = ?");
                PropertiesType propType = new PropertiesType();
                while (rs.next()) {
                    long id = JDBCUtils.getLong((ResultSet)rs, (String)"id");
                    Properties props = new Properties();
                    props.put("standard.expression", JDBCUtils.getString((ResultSet)rs, (String)"expression"));
                    props.put("standard.link", JDBCUtils.getString((ResultSet)rs, (String)"replacement"));
                    JDBCUtils.setString((PreparedStatement)update, (int)1, (String)propType.toString(props));
                    JDBCUtils.setLong((PreparedStatement)update, (int)2, (Long)id);
                    update.executeUpdate();
                }
            }
            finally {
                JDBCUtils.close((PreparedStatement)update);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)ps);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropColumn(Connection con, String table, String column) throws SQLException {
        CallableStatement stmt = null;
        try {
            stmt = con.prepareCall(String.format("ALTER TABLE %s DROP COLUMN %s", table, column));
            stmt.executeUpdate();
        }
        catch (Throwable throwable) {
            JDBCUtils.close(stmt);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTypeField(Connection con) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("UPDATE commit_message_transformer SET type = ?");
            JDBCUtils.setString((PreparedStatement)ps, (int)1, (String)"LINK");
            ps.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)ps);
        }
    }

    public String getName() {
        return "Commit message linkers.";
    }

    public String getDescription() {
        return "Migrate the commit message links to the new commit mesasge transformer schema.";
    }

    public boolean haltOnFailure() {
        return false;
    }
}

