/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.upgrade.tasks.HibernateUtils;
import com.zutubi.pulse.util.JDBCUtils;
import com.zutubi.pulse.util.logging.Logger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;

public class ClonedProjectDataPatchUpgradeTask
extends DatabaseUpgradeTask {
    private static final Logger LOG = Logger.getLogger(ClonedProjectDataPatchUpgradeTask.class);

    public String getName() {
        return "Cloned SCM data patch.";
    }

    public String getDescription() {
        return "This upgrade tasks fixes data problems resulting from cloned projects not cloning the scm details correctly. See CIB-409 for details.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(UpgradeContext context, Connection con) throws SQLException {
        LinkedList<Long> clonedScms = new LinkedList<Long>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            String selectClonedScms = "SELECT scm FROM project GROUP BY scm HAVING count(scm) > 1";
            ps = con.prepareStatement(selectClonedScms);
            rs = ps.executeQuery();
            while (rs.next()) {
                clonedScms.add(JDBCUtils.getLong((ResultSet)rs, (String)"scm"));
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(ps);
            JDBCUtils.close(rs);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)ps);
        JDBCUtils.close((ResultSet)rs);
        LinkedList<Scm> scmData = new LinkedList<Scm>();
        try {
            String selectScm = "SELECT * FROM scm WHERE id = ?";
            ps = con.prepareStatement(selectScm);
            Iterator i$ = clonedScms.iterator();
            while (i$.hasNext()) {
                long scmId = (Long)i$.next();
                JDBCUtils.setLong((PreparedStatement)ps, (int)1, (Long)scmId);
                rs = ps.executeQuery();
                if (rs.next()) {
                    scmData.add(new Scm(rs));
                }
                JDBCUtils.close((ResultSet)rs);
            }
        }
        finally {
            JDBCUtils.close((PreparedStatement)ps);
            JDBCUtils.close((ResultSet)rs);
        }
        PreparedStatement clone = null;
        PreparedStatement update = null;
        try {
            String selectProjects = "SELECT id FROM project WHERE scm = ?";
            ps = con.prepareStatement(selectProjects);
            String cloneScm = "INSERT INTO scm (id, scmtype, path, properties) VALUES (?, ?, ?, ?)";
            clone = con.prepareStatement(cloneScm);
            String updateProject = "UPDATE project SET scm = ? WHERE id = ?";
            update = con.prepareStatement(updateProject);
            for (Scm scm : scmData) {
                try {
                    JDBCUtils.setLong((PreparedStatement)ps, (int)1, (Long)scm.id);
                    rs = ps.executeQuery();
                    rs.next();
                    while (rs.next()) {
                        long projectId = JDBCUtils.getLong((ResultSet)rs, (String)"id");
                        long nextId = HibernateUtils.getNextId(con);
                        JDBCUtils.setLong((PreparedStatement)clone, (int)1, (Long)nextId);
                        JDBCUtils.setString((PreparedStatement)clone, (int)2, (String)scm.scmtype);
                        JDBCUtils.setString((PreparedStatement)clone, (int)3, (String)scm.path);
                        if (clone.executeUpdate() != 1) {
                            LOG.error("Failed to insert new scm.");
                        }
                        JDBCUtils.setLong((PreparedStatement)update, (int)1, (Long)nextId);
                        JDBCUtils.setLong((PreparedStatement)update, (int)2, (Long)projectId);
                        if (update.executeUpdate() == 1) continue;
                        LOG.error("Failed to update project " + projectId + " to reference new scm " + nextId + ".");
                    }
                }
                finally {
                    JDBCUtils.close((ResultSet)rs);
                }
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close((PreparedStatement)ps);
            JDBCUtils.close(clone);
            JDBCUtils.close(update);
            throw throwable;
        }
        JDBCUtils.close((PreparedStatement)ps);
        JDBCUtils.close((PreparedStatement)clone);
        JDBCUtils.close((PreparedStatement)update);
    }

    public boolean haltOnFailure() {
        return false;
    }

    private class Scm {
        public long id;
        public String scmtype;
        public String path;

        public Scm(ResultSet rs) throws SQLException {
            this.id = JDBCUtils.getLong((ResultSet)rs, (String)"id");
            this.scmtype = JDBCUtils.getString((ResultSet)rs, (String)"scmtype");
            this.path = JDBCUtils.getString((ResultSet)rs, (String)"path");
        }
    }
}

