/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.opensymphony.util.TextUtils;
import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.upgrade.tasks.HibernateUtils;
import com.zutubi.pulse.util.JDBCUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;

public class ChangeViewerUpgradeTask
extends DatabaseUpgradeTask {
    private static final String CHANGE_VIEWER_URL = "change.viewer.url";
    private long nextId;

    public String getName() {
        return "Change viewer data";
    }

    public String getDescription() {
        return "Data upgrades required for improved change viewer support.";
    }

    public boolean haltOnFailure() {
        return true;
    }

    public void execute(UpgradeContext context, Connection con) throws IOException, SQLException {
        this.nextId = HibernateUtils.getNextId(con);
        this.updateScms(con);
        this.updateFileRevisions(con);
        this.dropColumn(con);
        HibernateUtils.ensureNextId(con, this.nextId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateScms(Connection con) throws SQLException, IOException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement("SELECT id, properties FROM scm");
            rs = ps.executeQuery();
            while (rs.next()) {
                String propString = rs.getString(2);
                Properties p = new Properties();
                p.load(new ByteArrayInputStream(propString.getBytes()));
                this.updateScm(con, rs.getLong(1), p);
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)ps);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateScm(Connection con, long id, Properties properties) throws SQLException, IOException {
        String changeViewer = properties.getProperty(CHANGE_VIEWER_URL);
        if (TextUtils.stringSet((String)changeViewer)) {
            long viewerId = this.createChangeViewer(con, changeViewer);
            this.setProjectViewer(con, id, viewerId);
            properties.remove(CHANGE_VIEWER_URL);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            properties.store(bos, null);
            PreparedStatement ps = null;
            try {
                ps = con.prepareStatement("UPDATE scm SET properties = ? WHERE id = ?");
                ps.setString(1, bos.toString());
                ps.setLong(2, id);
                ps.executeUpdate();
            }
            finally {
                JDBCUtils.close((PreparedStatement)ps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createChangeViewer(Connection con, String changesetURL) throws SQLException {
        long id = this.nextId++;
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("INSERT INTO change_viewer VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
            ps.setLong(1, id);
            ps.setString(2, "CUSTOM");
            ps.setString(3, changesetURL);
            ps.setNull(4, 12);
            ps.setNull(5, 12);
            ps.setNull(6, 12);
            ps.setNull(7, 12);
            ps.setNull(8, 12);
            ps.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)ps);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setProjectViewer(Connection con, long scmId, long viewerId) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("UPDATE project SET change_viewer = ? WHERE scm = ?");
            ps.setLong(1, viewerId);
            ps.setLong(2, scmId);
            ps.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFileRevisions(Connection con) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = con.prepareStatement("SELECT id, revision FROM change");
            rs = ps.executeQuery();
            while (rs.next()) {
                this.updateChange(con, rs.getLong(1), rs.getString(2));
            }
        }
        catch (Throwable throwable) {
            JDBCUtils.close(rs);
            JDBCUtils.close((PreparedStatement)ps);
            throw throwable;
        }
        JDBCUtils.close((ResultSet)rs);
        JDBCUtils.close((PreparedStatement)ps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateChange(Connection con, long id, String revision) throws SQLException {
        long revisionId = this.nextId++;
        if (revision.contains(".")) {
            this.insertCVSRevision(con, revisionId, revision);
        } else {
            this.insertNumericalRevision(con, revisionId, Long.parseLong(revision));
        }
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("UPDATE change SET revision_id = ? WHERE id = ?");
            ps.setLong(1, revisionId);
            ps.setLong(2, id);
            ps.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertCVSRevision(Connection con, long revisionId, String revision) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("INSERT INTO file_revision VALUES (?, ?, ?, ?)");
            ps.setLong(1, revisionId);
            ps.setString(2, "CVS");
            ps.setString(3, revision);
            ps.setNull(4, -5);
            ps.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertNumericalRevision(Connection con, long revisionId, long revision) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("INSERT INTO file_revision VALUES (?, ?, ?, ?)");
            ps.setLong(1, revisionId);
            ps.setString(2, "NUMERICAL");
            ps.setNull(3, 12);
            ps.setLong(4, revision);
            ps.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)ps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropColumn(Connection con) throws SQLException {
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement("ALTER TABLE change DROP COLUMN revision");
            ps.executeUpdate();
        }
        finally {
            JDBCUtils.close((PreparedStatement)ps);
        }
    }
}

