/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.bootstrap.MasterConfigurationManager;
import com.zutubi.pulse.upgrade.ConfigurationAware;
import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.UpgradeException;
import com.zutubi.pulse.upgrade.UpgradeTask;
import com.zutubi.pulse.util.logging.Logger;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupUpgradeTask
implements UpgradeTask,
ConfigurationAware {
    private static final Logger LOG = Logger.getLogger(BackupUpgradeTask.class);
    private MasterConfigurationManager configurationManager;
    private List<String> errors = new LinkedList<String>();

    @Override
    public String getName() {
        return "Backup";
    }

    @Override
    public String getDescription() {
        return "Creates a backup of your embedded pulse database (will NOT backup an external database).";
    }

    @Override
    public int getBuildNumber() {
        return -1;
    }

    @Override
    public void execute(UpgradeContext context) throws UpgradeException {
        try {
            this.configurationManager.getData().backup(this.configurationManager.getSystemPaths());
        }
        catch (Exception e) {
            LOG.severe((Throwable)e);
            this.errors.add(e.getMessage());
        }
    }

    @Override
    public List<String> getErrors() {
        return this.errors;
    }

    @Override
    public boolean haltOnFailure() {
        return true;
    }

    @Override
    public boolean hasFailed() {
        return this.errors.size() != 0;
    }

    @Override
    public void setConfigurationManager(MasterConfigurationManager configurationManager) {
        this.configurationManager = configurationManager;
    }
}

