/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade.tasks;

import com.zutubi.pulse.bootstrap.DatabaseConsole;
import com.zutubi.pulse.upgrade.UpgradeContext;
import com.zutubi.pulse.upgrade.tasks.DatabaseUpgradeTask;
import com.zutubi.pulse.upgrade.tasks.HackyConnectionProvider;
import com.zutubi.pulse.upgrade.tasks.MutableConfiguration;
import com.zutubi.pulse.upgrade.tasks.SchemaRefactor;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.springframework.core.io.ClassPathResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSchemaRefactorUpgradeTask
extends DatabaseUpgradeTask {
    private List<String> mappings = new LinkedList<String>();
    private DatabaseConsole databaseConsole;

    @Override
    public boolean haltOnFailure() {
        return true;
    }

    @Override
    public void execute(UpgradeContext context, Connection con) throws IOException, SQLException {
        MutableConfiguration config = new MutableConfiguration();
        Properties props = this.databaseConsole.getConfig().getHibernateProperties();
        props.put("hibernate.connection.provider_class", "com.zutubi.pulse.upgrade.tasks.HackyConnectionProvider");
        HackyConnectionProvider.dataSource = this.dataSource;
        for (String mapping : this.mappings) {
            ClassPathResource resource = new ClassPathResource(mapping);
            config.addInputStream(resource.getInputStream());
        }
        config.buildMappings();
        SchemaRefactor refactor = new SchemaRefactor(config, props);
        this.doRefactor(context, con, refactor);
    }

    protected abstract void doRefactor(UpgradeContext var1, Connection var2, SchemaRefactor var3) throws SQLException;

    public void setDatabaseConsole(DatabaseConsole databaseConsole) {
        this.databaseConsole = databaseConsole;
    }

    public void setMappings(List<String> mappings) {
        this.mappings = mappings;
    }
}

