/*
 * Decompiled with CFR 0.152.
 */
package com.zutubi.pulse.upgrade;

import com.zutubi.pulse.upgrade.UpgradeTask;
import com.zutubi.pulse.upgrade.UpgradeTaskProgress;
import com.zutubi.pulse.util.TimeStamps;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpgradeProgressMonitor {
    private long startTimestamp;
    private long finishTimestamp;
    private int taskCount;
    private int tasksFinishedCount;
    private int percentageComplete = 0;
    private boolean error = false;
    private List<UpgradeTaskProgress> orderedProgressDetails = new LinkedList<UpgradeTaskProgress>();
    private Map<UpgradeTask, UpgradeTaskProgress> progressLookupMap = new HashMap<UpgradeTask, UpgradeTaskProgress>();

    protected void start() {
        this.startTimestamp = System.currentTimeMillis();
        this.percentageComplete = 0;
    }

    protected void stop() {
        this.finishTimestamp = System.currentTimeMillis();
    }

    protected void start(UpgradeTask task) {
        this.getTaskProgress(task).setStatus("in progress");
    }

    protected void complete(UpgradeTask task) {
        this.getTaskProgress(task).setStatus("complete");
        ++this.tasksFinishedCount;
    }

    protected void failed(UpgradeTask task) {
        UpgradeTaskProgress taskProgress = this.getTaskProgress(task);
        taskProgress.setStatus("failed");
        for (String msg : task.getErrors()) {
            taskProgress.setMessage(msg);
        }
        ++this.tasksFinishedCount;
        this.error = true;
    }

    protected void aborted(UpgradeTask task) {
        this.getTaskProgress(task).setStatus("aborted");
        ++this.tasksFinishedCount;
    }

    public boolean isStarted() {
        return this.startTimestamp != 0L;
    }

    public boolean isSuccessful() {
        return !this.error;
    }

    public boolean isError() {
        return this.error;
    }

    public String getElaspedTime() {
        if (this.startTimestamp == 0L) {
            return TimeStamps.getPrettyElapsed((long)0L);
        }
        long elapsedTime = this.finishTimestamp == 0L ? System.currentTimeMillis() - this.startTimestamp : this.finishTimestamp - this.startTimestamp;
        return TimeStamps.getPrettyElapsed((long)elapsedTime);
    }

    public int getPercentageComplete() {
        if (this.percentageComplete != 0) {
            return this.percentageComplete;
        }
        if (this.taskCount == 0) {
            return 100;
        }
        return (int)(100.0f * (float)this.tasksFinishedCount / (float)this.taskCount);
    }

    public void setPercentageComplete(int percentageComplete) {
        this.percentageComplete = percentageComplete;
    }

    protected void setTasks(List<UpgradeTask> monitoredTasks) {
        for (UpgradeTask task : monitoredTasks) {
            UpgradeTaskProgress progress = new UpgradeTaskProgress(task);
            this.progressLookupMap.put(task, progress);
            this.orderedProgressDetails.add(progress);
        }
        this.taskCount = monitoredTasks.size();
    }

    public List<UpgradeTaskProgress> getTaskProgress() {
        return Collections.unmodifiableList(this.orderedProgressDetails);
    }

    public UpgradeTaskProgress getTaskProgress(UpgradeTask task) {
        return this.progressLookupMap.get(task);
    }
}

